/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.imapmailbox.external.james.host;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetSocketAddress;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.imapmailbox.external.james.host.ExternalJamesUserAdder;
import org.apache.james.mpt.monitor.NullMonitor;

@Singleton
public class ExternalJamesHostSystem
extends ExternalHostSystem {
    private static final String ENV_JAMES_ADDRESS = "JAMES_ADDRESS";
    private static final String ENV_JAMES_IMAP_PORT = "JAMES_IMAP_PORT";
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private static final String SHABANG = "* OK IMAP4rev1 Server ready";
    private final Supplier<InetSocketAddress> addressSupplier;

    @Inject
    private ExternalJamesHostSystem(ExternalJamesUserAdder userAdder) {
        super(SUPPORTED_FEATURES, (Monitor)new NullMonitor(), SHABANG, (UserAdder)userAdder);
        Preconditions.checkState((System.getenv(ENV_JAMES_ADDRESS) != null ? 1 : 0) != 0, (Object)"You must have exported an environment variable called JAMES_ADDRESS in order to run these tests. For instance export JAMES_ADDRESS=127.0.0.1");
        Preconditions.checkState((System.getenv(ENV_JAMES_IMAP_PORT) != null ? 1 : 0) != 0, (Object)"You must have exported an environment variable called JAMES_IMAP_PORT in order to run these tests. For instance export JAMES_IMAP_PORT=143");
        this.addressSupplier = () -> new InetSocketAddress(System.getenv(ENV_JAMES_ADDRESS), Integer.parseInt(System.getenv(ENV_JAMES_IMAP_PORT)));
    }

    protected InetSocketAddress getAddress() {
        return (InetSocketAddress)this.addressSupplier.get();
    }

    public boolean addUser(String user, String password) throws Exception {
        return super.addUser(user, password);
    }

    public void beforeTest() throws Exception {
    }

    public void afterTest() throws Exception {
    }

    public void createMailbox(MailboxPath mailboxPath) {
        throw new NotImplementedException();
    }

    public void setQuotaLimits(long maxMessageQuota, long maxStorageQuota) throws Exception {
        throw new NotImplementedException();
    }
}

