/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.api;

import org.apache.james.mpt.api.ImapFeatures;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ImapFeaturesTest {
    @Test
    public void supportedFeaturesShouldReturnEmptySetWhenNoFeatures() {
        Assertions.assertThat((Iterable)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supportedFeatures()).isEmpty();
    }

    @Test
    public void supportedFeaturesShouldReturnNamespaceInSetWhenNamespaceSupported() {
        Assertions.assertThat((Iterable)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supportedFeatures()).containsExactly((Object[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    }

    @Test
    public void supportsShouldReturnFalseOnNamespaceWhenNamespaceIsNotSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT})).isFalse();
    }

    @Test
    public void supportsShouldReturnTrueOnNamespaceWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT})).isTrue();
    }

    @Test
    public void supportsShouldReturnTrueOnDuplicateNamespaceEntryWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT, ImapFeatures.Feature.NAMESPACE_SUPPORT})).isTrue();
    }

    @Test
    public void supportsShouldReturnTrueOnEmptyListWhenNamespaceIsSupported() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT}).supports(new ImapFeatures.Feature[0])).isTrue();
    }

    @Test
    public void supportsShouldReturnTrueOnEmptyListWhenNoFeatures() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[0])).isTrue();
    }

    @Test(expected=NullPointerException.class)
    public void supportsShouldThrowOnNullFeature() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports(new ImapFeatures.Feature[]{null}));
    }

    @Test(expected=NullPointerException.class)
    public void supportsShouldThrowOnNullFeatureArray() {
        Assertions.assertThat((boolean)ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[0]).supports((ImapFeatures.Feature[])null));
    }

    @Test(expected=NullPointerException.class)
    public void ofShouldThrowOnNullFeature() {
        ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{null});
    }

    @Test(expected=NullPointerException.class)
    public void ofShouldThrowOnNullFeatureArray() {
        ImapFeatures.of((ImapFeatures.Feature[])null);
    }
}

