/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import java.io.Reader;
import java.io.StringReader;
import org.apache.james.mpt.api.ProtocolInteractor;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;

public class TestFileProtocolSessionBuilder
extends MockObjectTestCase {
    private static final String SCRIPT_WITH_VARIABLES = "HELLO ${not} ${foo} WORLD ${bar}";
    private static final String SCRIPT_WITH_FOO_REPLACED_BY_WHATEVER = "HELLO ${not} whatever WORLD ${bar}";
    private static final String SCRIPT_WITH_VARIABLES_INLINED = "HELLO not foo WORLD bar";
    ProtocolSessionBuilder builder;
    ProtocolInteractor session;
    private Mock mockSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new ProtocolSessionBuilder();
        this.mockSession = this.mock(ProtocolInteractor.class);
        this.session = (ProtocolInteractor)this.mockSession.proxy();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void addLines() throws Exception {
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: HELLO ${not} ${foo} WORLD ${bar}"), this.session);
    }

    public void testShouldPreserveContentsWhenNoVariablesSet() throws Exception {
        this.mockSession.expects(this.once()).method("CL").with((Constraint)this.eq(-1), (Constraint)this.eq(SCRIPT_WITH_VARIABLES));
        this.addLines();
    }

    public void testShouldReplaceVariableWhenSet() throws Exception {
        this.mockSession.expects(this.once()).method("CL").with((Constraint)this.eq(-1), (Constraint)this.eq(SCRIPT_WITH_FOO_REPLACED_BY_WHATEVER));
        this.builder.setVariable("foo", "whatever");
        this.addLines();
    }

    public void testShouldReplaceAllVariablesWhenSet() throws Exception {
        this.mockSession.expects(this.once()).method("CL").with((Constraint)this.eq(-1), (Constraint)this.eq(SCRIPT_WITH_VARIABLES_INLINED));
        this.builder.setVariable("bar", "bar");
        this.builder.setVariable("foo", "foo");
        this.builder.setVariable("not", "not");
        this.addLines();
    }

    public void testShouldReplaceVariableAtBeginningAndEnd() throws Exception {
        this.mockSession.expects(this.once()).method("CL").with((Constraint)this.eq(-1), (Constraint)this.eq("whatever Some Other Scriptwhateverwhatever"));
        this.builder.setVariable("foo", "whatever");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: ${foo} Some Other Script${foo}${foo}"), this.session);
    }

    public void testShouldIgnoreNotQuiteVariables() throws Exception {
        String NEARLY = "{foo}${}${foo Some Other Script${foo}";
        this.mockSession.expects(this.once()).method("CL").with((Constraint)this.eq(-1), (Constraint)this.eq("{foo}${}${foo Some Other Script${foo}"));
        this.builder.setVariable("foo", "whatever");
        this.builder.addProtocolLines("A Script", (Reader)new StringReader("C: {foo}${}${foo Some Other Script${foo}"), this.session);
    }
}

