/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import org.apache.james.mpt.DiscardProtocol;
import org.apache.james.mpt.api.Continuation;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.Session;
import org.apache.james.mpt.api.UserAdder;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.monitor.NullMonitor;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.jmock.core.Constraint;

public class TestExternalHostSystem
extends MockObjectTestCase {
    private static final String USER = "USER NAME";
    private static final String PASSWORD = "SOME PASSWORD";
    private static final String SHABANG = "This Is The Shabang";
    private static final int PORT = 10001;
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private DiscardProtocol protocol;
    private DiscardProtocol.Record record;
    private Continuation continuation;
    private UserAdder userAdder;
    private Mock mockUserAdder;

    protected void setUp() throws Exception {
        super.setUp();
        this.protocol = new DiscardProtocol(10001);
        this.protocol.start();
        this.record = this.protocol.recordNext();
        this.continuation = (Continuation)this.mock(Continuation.class).proxy();
        this.mockUserAdder = this.mock(UserAdder.class);
        this.userAdder = (UserAdder)this.mockUserAdder.proxy();
    }

    protected void tearDown() throws Exception {
        this.protocol.stop();
        super.tearDown();
    }

    public void testWrite() throws Exception {
        Session session = this.newSession(SHABANG);
        String in = "Hello, World";
        session.writeLine("Hello, World");
        session.stop();
        TestExternalHostSystem.assertEquals((String)"Hello, World\r\n", (String)this.record.complete());
    }

    public void testAddUser() throws Exception {
        this.mockUserAdder.expects(this.once()).method("addUser").with((Constraint)this.eq(USER), (Constraint)this.eq(PASSWORD));
        ExternalHostSystem system = this.buildSystem(SHABANG);
        system.addUser(USER, PASSWORD);
    }

    private Session newSession(String shabang) throws Exception {
        ExternalHostSystem system = this.buildSystem(shabang);
        return system.newSession(this.continuation);
    }

    private ExternalHostSystem buildSystem(String shabang) {
        return new ExternalHostSystem(SUPPORTED_FEATURES, "localhost", 10001, (Monitor)new NullMonitor(), shabang, this.userAdder);
    }
}

