/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import javax.net.SocketFactory;
import junit.framework.TestCase;
import org.apache.james.mpt.DiscardProtocol;

public class TestDiscardProtocol
extends TestCase {
    private static final String INPUT = "One, two, three - Testing";
    private static final int PORT = 10001;
    private DiscardProtocol protocol;
    private Socket socket;
    private DiscardProtocol.Record record;

    protected void setUp() throws Exception {
        super.setUp();
        this.protocol = new DiscardProtocol(10001);
        this.protocol.start();
        this.socket = SocketFactory.getDefault().createSocket("127.0.0.1", 10001);
        this.record = this.protocol.recordNext();
    }

    protected void tearDown() throws Exception {
        this.protocol.stop();
        super.tearDown();
    }

    public void testRecord() throws Exception {
        TestDiscardProtocol.assertTrue((boolean)this.socket.isConnected());
        this.input();
        String output = this.record.complete();
        TestDiscardProtocol.assertEquals((String)INPUT, (String)output);
    }

    private void input() throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(this.socket.getOutputStream());
        ((Writer)out).append(INPUT);
        ((Writer)out).close();
        this.socket.close();
    }

    public void testComplete() throws Exception {
        InputLater inputLater = new InputLater();
        Thread thread = new Thread(inputLater);
        thread.start();
        String output = this.record.complete();
        TestDiscardProtocol.assertEquals((String)INPUT, (String)output);
        inputLater.assertExecutedSuccessfully();
    }

    private final class InputLater
    implements Runnable {
        private Exception e;

        private InputLater() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                TestDiscardProtocol.this.input();
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public void assertExecutedSuccessfully() throws Exception {
            if (this.e != null) {
                this.e.printStackTrace();
                throw this.e;
            }
        }
    }
}

