/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.quota.search.Offset;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetTest {
    @Test
    public void shouldMatchBeanContract() {
        EqualsVerifier.forClass(Offset.class).verify();
    }

    @Test
    public void getValueShouldReturnZeroWhenNone() {
        Assertions.assertThat((int)Offset.none().getValue()).isEqualTo(0);
    }

    @Test
    public void getValueShouldReturnZeroWhenZero() {
        Assertions.assertThat((int)Offset.of((int)0).getValue()).isEqualTo(0);
    }

    @Test
    public void getValueShouldReturnSuppliedValue() {
        Assertions.assertThat((int)Offset.of((int)3).getValue()).isEqualTo(3);
    }

    @Test
    public void ofShouldThrowOnNegativeValue() {
        Assertions.assertThatThrownBy(() -> Offset.of((int)-1)).isInstanceOf(IllegalArgumentException.class);
    }
}

