/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.quota.search.Limit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LimitTest {
    LimitTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(Limit.class).verify();
    }

    @Test
    void getValueShouldReturnEmptyWhenUnlimited() {
        Assertions.assertThat((Optional)Limit.unlimited().getValue()).isEmpty();
    }

    @Test
    void getValueShouldReturnZeroWhenZero() {
        Assertions.assertThat((Optional)Limit.of((int)0).getValue()).contains((Object)0);
    }

    @Test
    void getValueShouldReturnSuppliedValue() {
        Assertions.assertThat((Optional)Limit.of((int)3).getValue()).contains((Object)3);
    }

    @Test
    void isLimitedShouldBeTrueWhenAValueIsSpecified() {
        Assertions.assertThat((boolean)Limit.of((int)3).isLimited()).isTrue();
    }

    @Test
    void isLimitedShouldBeFalseWhenUnlimited() {
        Assertions.assertThat((boolean)Limit.unlimited().isLimited()).isFalse();
    }

    @Test
    void ofShouldThrowOnNegativeValue() {
        Assertions.assertThatThrownBy(() -> Limit.of((int)-1)).isInstanceOf(IllegalArgumentException.class);
    }
}

