/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.core.CoreFixture;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaBoundaryFixture;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearchTestSystem;
import org.apache.james.user.api.UsersRepositoryException;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.Test;

public interface QuotaSearcherContract {
    public static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Durations.ONE_HUNDRED_MILLISECONDS).and().pollDelay(Durations.ONE_HUNDRED_MILLISECONDS).await();
    public static final String PASSWORD = "any";

    @Test
    default public void moreThanShouldFilterOutTooSmallValues(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.HOMER, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.HOMER, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(51));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().moreThan(QuotaBoundaryFixture._50))).containsOnly((Object[])new Username[]{CoreFixture.Users.Simpson.HOMER, CoreFixture.Users.Simpson.LISA}));
    }

    @Test
    default public void lessThanShouldFilterOutTooBigValues(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.HOMER, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.HOMER, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(51));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().lessThan(QuotaBoundaryFixture._50))).containsOnly((Object[])new Username[]{CoreFixture.Users.Simpson.HOMER, CoreFixture.Users.Simpson.BART}));
    }

    @Test
    default public void rangeShouldFilterValuesOutOfRange(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.HOMER, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(40));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.HOMER, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(60));
        this.appendMessage(testSystem, CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, this.withSize(80));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().moreThan(QuotaBoundaryFixture._50).lessThan(QuotaBoundaryFixture._75))).containsOnly((Object[])new Username[]{CoreFixture.Users.Simpson.HOMER, CoreFixture.Users.Simpson.LISA}));
    }

    @Test
    default public void hasDomainShouldFilterOutValuesWithDifferentDomains(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getDomainList().addDomain(CoreFixture.Domains.DOMAIN_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().hasDomain(CoreFixture.Domains.SIMPSON_COM))).containsOnly((Object[])new Username[]{CoreFixture.Users.Simpson.BART, CoreFixture.Users.Simpson.LISA}));
    }

    @Test
    default public void andShouldCombineClauses(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getDomainList().addDomain(CoreFixture.Domains.DOMAIN_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().hasDomain(CoreFixture.Domains.SIMPSON_COM).lessThan(QuotaBoundaryFixture._50))).containsOnly((Object[])new Username[]{CoreFixture.Users.Simpson.BART}));
    }

    @Test
    default public void resultShouldBeAlphabeticallyOrdered(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.ALPHABET_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.AAA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABB, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ACB, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.AAA, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABA, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ACB, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABB, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder())).containsExactly((Object[])new Username[]{CoreFixture.Users.Alphabet.AAA, CoreFixture.Users.Alphabet.ABA, CoreFixture.Users.Alphabet.ABB, CoreFixture.Users.Alphabet.ACB}));
    }

    @Test
    default public void limitShouldBeTheMaximumValueOfReturnedResults(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.ALPHABET_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.AAA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABB, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ACB, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.AAA, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABA, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ACB, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABB, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withLimit(Limit.of((int)2)))).containsOnly((Object[])new Username[]{CoreFixture.Users.Alphabet.AAA, CoreFixture.Users.Alphabet.ABA}));
    }

    @Test
    default public void offsetShouldSkipSomeResults(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.ALPHABET_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.AAA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABB, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ACB, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.AAA, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABA, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ACB, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABB, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withOffset(Offset.of((int)2)))).containsOnly((Object[])new Username[]{CoreFixture.Users.Alphabet.ABB, CoreFixture.Users.Alphabet.ACB}));
    }

    @Test
    default public void searchShouldReturnEmptyOnTooBigOffset(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.SIMPSON_COM);
        testSystem.getDomainList().addDomain(CoreFixture.Domains.DOMAIN_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.BART, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.HOMER, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Simpson.LISA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.BART, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.HOMER, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Simpson.LISA, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.BENOIT_AT_DOMAIN_TLD, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withOffset(Offset.of((int)5)))).isEmpty());
    }

    @Test
    default public void pagingShouldBeSupported(QuotaSearchTestSystem testSystem) throws Exception {
        testSystem.getDomainList().addDomain(CoreFixture.Domains.ALPHABET_TLD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.AAA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABA, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ABB, PASSWORD);
        testSystem.getUsersRepository().addUser(CoreFixture.Users.Alphabet.ACB, PASSWORD);
        testSystem.getMaxQuotaManager().setGlobalMaxStorage(QuotaSizeLimit.size((long)100L));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.AAA, this.withSize(49));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABA, this.withSize(50));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ACB, this.withSize(51));
        this.appendMessage(testSystem, CoreFixture.Users.Alphabet.ABB, this.withSize(50));
        testSystem.await();
        CALMLY_AWAIT.untilAsserted(() -> Assertions.assertThat((List)testSystem.getQuotaSearcher().search(QuotaQuery.builder().withLimit(Limit.of((int)2)).withOffset(Offset.of((int)1)))).containsExactly((Object[])new Username[]{CoreFixture.Users.Alphabet.ABA, CoreFixture.Users.Alphabet.ABB}));
    }

    default public void appendMessage(QuotaSearchTestSystem testSystem, Username username, MessageManager.AppendCommand appendCommand) throws MailboxException, UsersRepositoryException, DomainListException {
        MailboxManager mailboxManager = testSystem.getMailboxManager();
        MailboxSession session = mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.inbox((MailboxSession)session);
        mailboxManager.createMailbox(mailboxPath, session);
        mailboxManager.getMailbox(mailboxPath, session).appendMessage(appendCommand, session);
    }

    default public MessageManager.AppendCommand withSize(int size) {
        byte[] bytes = Strings.repeat((String)"a", (int)size).getBytes(StandardCharsets.UTF_8);
        return MessageManager.AppendCommand.from((Content)new ByteContent(bytes));
    }
}

