/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.Offset;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaBoundaryFixture;
import org.apache.james.quota.search.QuotaClause;
import org.apache.james.quota.search.QuotaQuery;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public class QuotaQueryTest {
    @Test
    public void shouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaQuery.class).verify();
    }

    @Test
    public void builderShouldProvideDefaults() {
        QuotaQuery quotaQuery = QuotaQuery.builder().build();
        SoftAssertions softly = new SoftAssertions();
        softly.assertThat((Object)quotaQuery.getClause()).isEqualTo((Object)QuotaClause.and((QuotaClause[])new QuotaClause[0]));
        softly.assertThat((Object)quotaQuery.getLimit()).isEqualTo((Object)Limit.unlimited());
        softly.assertThat((Object)quotaQuery.getOffset()).isEqualTo((Object)Offset.none());
        softly.assertAll();
    }

    @Test
    public void builderShouldUseProvidedValues() {
        Limit limit = Limit.of((int)10);
        Offset offset = Offset.of((int)50);
        QuotaQuery quotaQuery = QuotaQuery.builder().withLimit(limit).withOffset(offset).lessThan(QuotaBoundaryFixture._75).moreThan(QuotaBoundaryFixture._50).hasDomain(Domain.LOCALHOST).build();
        SoftAssertions softly = new SoftAssertions();
        softly.assertThat((Object)quotaQuery.getClause()).isEqualTo((Object)QuotaClause.and((QuotaClause[])new QuotaClause[]{QuotaClause.lessThan((QuotaBoundary)QuotaBoundaryFixture._75), QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._50), QuotaClause.hasDomain((Domain)Domain.LOCALHOST)}));
        softly.assertThat((Object)quotaQuery.getLimit()).isEqualTo((Object)limit);
        softly.assertThat((Object)quotaQuery.getOffset()).isEqualTo((Object)offset);
        softly.assertAll();
    }
}

