/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.core.Domain;
import org.apache.james.quota.search.QuotaBoundary;

public interface QuotaClause {
    public static LessThan lessThan(QuotaBoundary quotaBoundary) {
        return new LessThan(quotaBoundary);
    }

    public static MoreThan moreThan(QuotaBoundary quotaBoundary) {
        return new MoreThan(quotaBoundary);
    }

    public static HasDomain hasDomain(Domain domain) {
        return new HasDomain(domain);
    }

    public static And and(List<QuotaClause> clauses) {
        return new And(clauses);
    }

    public static And and(QuotaClause ... clauses) {
        return new And((List)ImmutableList.copyOf((Object[])clauses));
    }

    public static class And
    implements QuotaClause {
        private final ImmutableList<QuotaClause> clauses;

        private And(List<QuotaClause> clauses) {
            Preconditions.checkNotNull(clauses, (Object)"'clauses' is mandatory");
            Preconditions.checkArgument((boolean)this.doesNotContainAnd(clauses), (Object)"Nested And clauses are not supported");
            this.clauses = ImmutableList.copyOf(clauses);
        }

        private boolean doesNotContainAnd(List<QuotaClause> clauses) {
            return clauses.stream().noneMatch(clause -> clause instanceof And);
        }

        public List<QuotaClause> getClauses() {
            return this.clauses;
        }

        public final boolean equals(Object o) {
            if (o instanceof And) {
                And and = (And)o;
                return Objects.equals(this.clauses, and.clauses);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.clauses);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clauses", this.clauses).toString();
        }
    }

    public static class HasDomain
    implements QuotaClause {
        private final Domain domain;

        private HasDomain(Domain domain) {
            Preconditions.checkNotNull((Object)domain, (Object)"'domain' is mandatory");
            this.domain = domain;
        }

        public Domain getDomain() {
            return this.domain;
        }

        public final boolean equals(Object o) {
            if (o instanceof HasDomain) {
                HasDomain hasDomain = (HasDomain)o;
                return Objects.equals(this.domain, hasDomain.domain);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.domain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("domain", (Object)this.domain).toString();
        }
    }

    public static class MoreThan
    implements QuotaClause {
        private final QuotaBoundary quotaBoundary;

        private MoreThan(QuotaBoundary quotaBoundary) {
            Preconditions.checkNotNull((Object)quotaBoundary, (Object)"'quotaBoundary' is mandatory");
            this.quotaBoundary = quotaBoundary;
        }

        public QuotaBoundary getQuotaBoundary() {
            return this.quotaBoundary;
        }

        public final boolean equals(Object o) {
            if (o instanceof MoreThan) {
                MoreThan moreThan = (MoreThan)o;
                return Objects.equals(this.quotaBoundary, moreThan.quotaBoundary);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.quotaBoundary);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("quotaRatio", (Object)this.quotaBoundary).toString();
        }
    }

    public static class LessThan
    implements QuotaClause {
        private final QuotaBoundary quotaBoundary;

        private LessThan(QuotaBoundary quotaBoundary) {
            Preconditions.checkNotNull((Object)quotaBoundary, (Object)"'quotaBoundary' is mandatory");
            this.quotaBoundary = quotaBoundary;
        }

        public QuotaBoundary getQuotaBoundary() {
            return this.quotaBoundary;
        }

        public final boolean equals(Object o) {
            if (o instanceof LessThan) {
                LessThan lessThan = (LessThan)o;
                return Objects.equals(this.quotaBoundary, lessThan.quotaBoundary);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.quotaBoundary);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("quotaBoundary", (Object)this.quotaBoundary).toString();
        }
    }
}

