/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search;

import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.quota.search.QuotaBoundary;
import org.apache.james.quota.search.QuotaBoundaryFixture;
import org.apache.james.quota.search.QuotaClause;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuotaClauseTest {
    @Test
    public void lessThanShouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaClause.LessThan.class).verify();
    }

    @Test
    public void moreThanShouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaClause.MoreThan.class).verify();
    }

    @Test
    public void hasDomainShouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaClause.HasDomain.class).verify();
    }

    @Test
    public void andShouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaClause.And.class).verify();
    }

    @Test
    public void lessThanClauseShouldThrowWhenQuotaThresholdIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaClause.lessThan(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void moreThanClauseShouldThrowWhenQuotaThresholdIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaClause.moreThan(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void hasDomainClauseShouldThrowWhenDomainIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaClause.hasDomain(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void andClauseShouldThrowWhenClauseIsNull() {
        List clauses = null;
        Assertions.assertThatThrownBy(() -> QuotaClause.and((List)clauses)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void lessThanClauseShouldInstanciate() {
        QuotaClause.LessThan lessThanQuery = QuotaClause.lessThan((QuotaBoundary)QuotaBoundaryFixture._50);
        Assertions.assertThat((Object)lessThanQuery.getQuotaBoundary()).isEqualTo((Object)QuotaBoundaryFixture._50);
    }

    @Test
    public void moreThanClauseShouldInstanciate() {
        QuotaClause.MoreThan moreThanQuery = QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._50);
        Assertions.assertThat((Object)moreThanQuery.getQuotaBoundary()).isEqualTo((Object)QuotaBoundaryFixture._50);
    }

    @Test
    public void hasDomainClauseShouldInstanciate() {
        Domain domain = Domain.of((String)"domain.org");
        QuotaClause.HasDomain hasDomainQuery = QuotaClause.hasDomain((Domain)domain);
        Assertions.assertThat((Object)hasDomainQuery.getDomain()).isEqualTo((Object)domain);
    }

    @Test
    public void andClauseShouldInstanciate() {
        QuotaClause.MoreThan first = QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._50);
        QuotaClause.MoreThan second = QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._75);
        QuotaClause.And andQuery = QuotaClause.and((QuotaClause[])new QuotaClause[]{first, second});
        Assertions.assertThat((List)andQuery.getClauses()).containsExactly((Object[])new QuotaClause[]{first, second});
    }

    @Test
    public void nestedAndClausesAreNotSupported() {
        QuotaClause.MoreThan first = QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._50);
        QuotaClause.MoreThan second = QuotaClause.moreThan((QuotaBoundary)QuotaBoundaryFixture._75);
        Assertions.assertThatThrownBy(() -> QuotaClause.and((QuotaClause[])new QuotaClause[]{first, QuotaClause.and((QuotaClause[])new QuotaClause[]{second})})).isInstanceOf(IllegalArgumentException.class);
    }
}

