/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch.json;

import java.io.IOException;
import java.time.Instant;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.quota.QuotaFixture;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.quota.search.opensearch.json.QuotaRatioToOpenSearchJson;
import org.apache.james.util.ClassLoaderUtils;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class QuotaRatioToOpenSearchJsonTest {
    static Event.EventId EVENT_ID = Event.EventId.of((String)"6e0dd59d-660e-4d9b-b22f-0354479f47b4");

    QuotaRatioToOpenSearchJsonTest() {
    }

    @Test
    void quotaRatioShouldBeWellConvertedToJson() throws IOException {
        String user = "user@domain.org";
        DefaultUserQuotaRootResolver quotaRootResolver = new DefaultUserQuotaRootResolver((SessionProvider)Mockito.mock(SessionProvider.class), (MailboxSessionMapperFactory)Mockito.mock(MailboxSessionMapperFactory.class));
        Username username = Username.of((String)user);
        MailboxEvents.QuotaUsageUpdatedEvent event = ((EventFactory.QuotaUsageUpdatedFinalStage)((EventFactory.RequireInstant)((EventFactory.RequireQuotaSize)((EventFactory.RequireQuotaCount)((EventFactory.RequireQuotaRoot)((EventFactory.RequireUser)EventFactory.quotaUpdated().eventId(EVENT_ID)).user(username)).quotaRoot(quotaRootResolver.forUser(username))).quotaCount(QuotaFixture.Counts._52_PERCENT)).quotaSize(QuotaFixture.Sizes._55_PERCENT)).instant(Instant.now())).build();
        QuotaRatioToOpenSearchJson quotaRatioToOpenSearchJson = new QuotaRatioToOpenSearchJson((QuotaRootResolver)quotaRootResolver);
        String convertToJson = quotaRatioToOpenSearchJson.convertToJson(event);
        JsonAssertions.assertThatJson((Object)convertToJson).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)ClassLoaderUtils.getSystemResourceAsString((String)"quotaRatio.json"));
    }

    @Test
    void quotaRatioShouldBeWellConvertedToJsonWhenNoDomain() throws IOException {
        String user = "user";
        DefaultUserQuotaRootResolver quotaRootResolver = new DefaultUserQuotaRootResolver((SessionProvider)Mockito.mock(SessionProvider.class), (MailboxSessionMapperFactory)Mockito.mock(MailboxSessionMapperFactory.class));
        Username username = Username.of((String)user);
        MailboxEvents.QuotaUsageUpdatedEvent event = ((EventFactory.QuotaUsageUpdatedFinalStage)((EventFactory.RequireInstant)((EventFactory.RequireQuotaSize)((EventFactory.RequireQuotaCount)((EventFactory.RequireQuotaRoot)((EventFactory.RequireUser)EventFactory.quotaUpdated().eventId(EVENT_ID)).user(username)).quotaRoot(quotaRootResolver.forUser(username))).quotaCount(QuotaFixture.Counts._52_PERCENT)).quotaSize(QuotaFixture.Sizes._55_PERCENT)).instant(Instant.now())).build();
        QuotaRatioToOpenSearchJson quotaRatioToOpenSearchJson = new QuotaRatioToOpenSearchJson((QuotaRootResolver)quotaRootResolver);
        String convertToJson = quotaRatioToOpenSearchJson.convertToJson(event);
        JsonAssertions.assertThatJson((Object)convertToJson).when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)ClassLoaderUtils.getSystemResourceAsString((String)"quotaRatioNoDomain.json"));
    }
}

