/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.inmemory.quota.InMemoryCurrentQuotaManager;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.mailbox.store.quota.QuotaRootImpl;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class InMemoryCurrentQuotaManagerTest {
    public static final QuotaRoot QUOTA_ROOT = QuotaRootImpl.quotaRoot((String)"benwa");
    private InMemoryCurrentQuotaManager testee;
    private CurrentQuotaCalculator mockedCurrentQuotaCalculator;

    @Before
    public void setUp() throws Exception {
        this.mockedCurrentQuotaCalculator = (CurrentQuotaCalculator)Mockito.mock(CurrentQuotaCalculator.class);
        MailboxManager mockedMailboxManager = (MailboxManager)Mockito.mock(MailboxManager.class);
        this.testee = new InMemoryCurrentQuotaManager(this.mockedCurrentQuotaCalculator, mockedMailboxManager);
    }

    @Test
    public void getCurrentMessageCountShouldReturnRecalculateMessageCountWhenEntryIsNotInitialized() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenAnswer((Answer)new Answer<CurrentQuotaCalculator.CurrentQuotas>(){

            public CurrentQuotaCalculator.CurrentQuotas answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new CurrentQuotaCalculator.CurrentQuotas(18L, 512L);
            }
        });
        Assertions.assertThat((long)this.testee.getCurrentMessageCount(QUOTA_ROOT)).isEqualTo(18L);
    }

    @Test
    public void getCurrentStorageShouldReturnRecalculateSizeWhenEntryIsNotInitialized() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenAnswer((Answer)new Answer<CurrentQuotaCalculator.CurrentQuotas>(){

            public CurrentQuotaCalculator.CurrentQuotas answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new CurrentQuotaCalculator.CurrentQuotas(18L, 512L);
            }
        });
        Assertions.assertThat((long)this.testee.getCurrentStorage(QUOTA_ROOT)).isEqualTo(512L);
    }

    @Test
    public void getCurrentStorageShouldReRetrieveStoredQuotasWhenCalculateOnUnknownQuotaIsTrue() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenAnswer((Answer)new Answer<CurrentQuotaCalculator.CurrentQuotas>(){

            public CurrentQuotaCalculator.CurrentQuotas answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new CurrentQuotaCalculator.CurrentQuotas(18L, 512L);
            }
        });
        this.testee.increase(QUOTA_ROOT, 10L, 100L);
        Assertions.assertThat((long)this.testee.getCurrentMessageCount(QUOTA_ROOT)).isEqualTo(28L);
        Assertions.assertThat((long)this.testee.getCurrentStorage(QUOTA_ROOT)).isEqualTo(612L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void increaseShouldThrowOnZeroCount() throws Exception {
        this.testee.increase(QUOTA_ROOT, 0L, 5L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void increaseShouldThrowOnNegativeCount() throws Exception {
        this.testee.increase(QUOTA_ROOT, -1L, 5L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void increaseShouldThrowOnZeroSize() throws Exception {
        this.testee.increase(QUOTA_ROOT, 5L, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void increaseShouldThrowOnNegativeSize() throws Exception {
        this.testee.increase(QUOTA_ROOT, 5L, -1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void decreaseShouldThrowOnZeroCount() throws Exception {
        this.testee.decrease(QUOTA_ROOT, 0L, 5L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void decreaseShouldThrowOnNegativeCount() throws Exception {
        this.testee.decrease(QUOTA_ROOT, -1L, 5L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void decreaseShouldThrowOnZeroSize() throws Exception {
        this.testee.decrease(QUOTA_ROOT, 5L, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void decreaseShouldThrowOnNegativeSize() throws Exception {
        this.testee.decrease(QUOTA_ROOT, 5L, -1L);
    }
}

