/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.manager;

import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.InMemoryMessageIdManager;
import org.apache.james.mailbox.inmemory.quota.InMemoryCurrentQuotaManager;
import org.apache.james.mailbox.inmemory.quota.InMemoryPerUserMaxQuotaManager;
import org.apache.james.mailbox.manager.IntegrationResources;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.NoMailboxPathLocker;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.mailbox.store.quota.DefaultQuotaRootResolver;
import org.apache.james.mailbox.store.quota.ListeningCurrentQuotaUpdater;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;
import org.apache.james.mailbox.store.quota.StoreQuotaManager;

public class InMemoryIntegrationResources
implements IntegrationResources {
    private SimpleGroupMembershipResolver groupMembershipResolver;
    private DefaultQuotaRootResolver quotaRootResolver;

    public MailboxManager createMailboxManager(GroupMembershipResolver groupMembershipResolver) throws MailboxException {
        FakeAuthenticator fakeAuthenticator = new FakeAuthenticator();
        fakeAuthenticator.addUser("user@domain.org", "pass");
        InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
        InMemoryMailboxManager manager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (Authenticator)fakeAuthenticator, (Authorizator)FakeAuthorizator.defaultReject(), (MailboxPathLocker)new NoMailboxPathLocker(), (MailboxACLResolver)new UnionMailboxACLResolver(), groupMembershipResolver, new MessageParser(), (MessageId.Factory)new InMemoryMessageId.Factory());
        manager.init();
        return manager;
    }

    public MessageIdManager createMessageIdManager(MailboxManager mailboxManager) {
        return new InMemoryMessageIdManager(mailboxManager);
    }

    public QuotaManager createQuotaManager(MaxQuotaManager maxQuotaManager, MailboxManager mailboxManager) throws Exception {
        StoreQuotaManager quotaManager = new StoreQuotaManager();
        quotaManager.setCalculateWhenUnlimited(false);
        DefaultQuotaRootResolver quotaRootResolver = this.createQuotaRootResolver(mailboxManager);
        InMemoryCurrentQuotaManager currentQuotaManager = new InMemoryCurrentQuotaManager(new CurrentQuotaCalculator(((StoreMailboxManager)mailboxManager).getMapperFactory(), (QuotaRootResolver)quotaRootResolver), mailboxManager);
        ListeningCurrentQuotaUpdater listeningCurrentQuotaUpdater = new ListeningCurrentQuotaUpdater();
        listeningCurrentQuotaUpdater.setQuotaRootResolver((QuotaRootResolver)quotaRootResolver);
        listeningCurrentQuotaUpdater.setCurrentQuotaManager((StoreCurrentQuotaManager)currentQuotaManager);
        quotaManager.setCurrentQuotaManager((CurrentQuotaManager)currentQuotaManager);
        quotaManager.setMaxQuotaManager(maxQuotaManager);
        ((StoreMailboxManager)mailboxManager).setQuotaManager((QuotaManager)quotaManager);
        mailboxManager.addGlobalListener((MailboxListener)listeningCurrentQuotaUpdater, null);
        return quotaManager;
    }

    public MaxQuotaManager createMaxQuotaManager() throws Exception {
        return new InMemoryPerUserMaxQuotaManager();
    }

    public GroupMembershipResolver createGroupMembershipResolver() throws Exception {
        this.groupMembershipResolver = new SimpleGroupMembershipResolver();
        return this.groupMembershipResolver;
    }

    public DefaultQuotaRootResolver createQuotaRootResolver(MailboxManager mailboxManager) throws Exception {
        if (this.quotaRootResolver == null) {
            this.quotaRootResolver = new DefaultQuotaRootResolver(((StoreMailboxManager)mailboxManager).getMapperFactory());
        }
        return this.quotaRootResolver;
    }

    public void init() throws MailboxException {
    }

    public void clean() throws MailboxException {
    }
}

