/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.NotImplementedException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MapperProvider;
import org.apache.james.mailbox.store.mail.model.MessageUidProvider;

public class InMemoryMapperProvider
implements MapperProvider {
    private final Random random = new Random();
    private final MessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
    private final MessageUidProvider messageUidProvider = new MessageUidProvider();
    private final InMemoryMailboxSessionMapperFactory inMemoryMailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();

    public MailboxMapper createMailboxMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createMailboxMapper((MailboxSession)new MockMailboxSession("user"));
    }

    public MessageMapper createMessageMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createMessageMapper((MailboxSession)new MockMailboxSession("user"));
    }

    public MessageIdMapper createMessageIdMapper() throws MailboxException {
        throw new NotImplementedException();
    }

    public AttachmentMapper createAttachmentMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createAttachmentMapper((MailboxSession)new MockMailboxSession("user"));
    }

    public InMemoryId generateId() {
        return InMemoryId.of((long)this.random.nextInt());
    }

    public MessageUid generateMessageUid() {
        return this.messageUidProvider.next();
    }

    public void clearMapper() throws MailboxException {
        this.inMemoryMailboxSessionMapperFactory.deleteAll();
    }

    public void ensureMapperPrepared() throws MailboxException {
    }

    public boolean supportPartialAttachmentFetch() {
        return false;
    }

    public AnnotationMapper createAnnotationMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createAnnotationMapper((MailboxSession)new MockMailboxSession("user"));
    }

    public MessageId generateMessageId() {
        return this.messageIdFactory.generate();
    }

    public List<MapperProvider.Capabilities> getSupportedCapabilities() {
        return ImmutableList.of((Object)MapperProvider.Capabilities.MESSAGE, (Object)MapperProvider.Capabilities.MAILBOX, (Object)MapperProvider.Capabilities.ATTACHMENT, (Object)MapperProvider.Capabilities.ANNOTATION, (Object)MapperProvider.Capabilities.MOVE);
    }

    public long generateModSeq(Mailbox mailbox) throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.getModSeqProvider().nextModSeq((MailboxSession)new MockMailboxSession("user"), mailbox);
    }

    public long highestModSeq(Mailbox mailbox) throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.getModSeqProvider().highestModSeq((MailboxSession)new MockMailboxSession("user"), mailbox);
    }

    public void close() throws IOException {
    }
}

