/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.io.InputStream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.AbstractMailboxManagerAttachmentTest;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.NoMailboxPathLocker;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class InMemoryMailboxManagerAttachmentTest
extends AbstractMailboxManagerAttachmentTest {
    private InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
    private InMemoryMailboxManager mailboxManager;
    private InMemoryMailboxManager parseFailingMailboxManager;

    public InMemoryMailboxManagerAttachmentTest() throws Exception {
        Authenticator noAuthenticator = null;
        Authorizator noAuthorizator = null;
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        this.mailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)this.mailboxSessionMapperFactory, noAuthenticator, noAuthorizator, (MailboxPathLocker)new NoMailboxPathLocker(), (MailboxACLResolver)new UnionMailboxACLResolver(), null, new MessageParser(), (MessageId.Factory)messageIdFactory);
        this.mailboxManager.init();
        MessageParser failingMessageParser = (MessageParser)Mockito.mock(MessageParser.class);
        Mockito.when((Object)failingMessageParser.retrieveAttachments((InputStream)Matchers.any(InputStream.class))).thenThrow(new Throwable[]{new RuntimeException("Message parser set to fail")});
        this.parseFailingMailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)this.mailboxSessionMapperFactory, noAuthenticator, noAuthorizator, (MailboxPathLocker)new NoMailboxPathLocker(), (MailboxACLResolver)new UnionMailboxACLResolver(), null, failingMessageParser, (MessageId.Factory)messageIdFactory);
        this.parseFailingMailboxManager.init();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected MailboxSessionMapperFactory getMailboxSessionMapperFactory() {
        return this.mailboxSessionMapperFactory;
    }

    protected MailboxManager getParseFailingMailboxManager() {
        return this.parseFailingMailboxManager;
    }
}

