/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.base.Throwables;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryCombinationManagerTestSystem;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.InMemoryMessageIdManager;
import org.apache.james.mailbox.inmemory.InMemoryMessageIdManagerTestSystem;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.CombinationManagerTestSystem;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageIdManagerTestSystem;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;

public class MessageIdManagerTestSystemProvider {
    private static final int LIMIT_ANNOTATIONS = 3;
    private static final int LIMIT_ANNOTATION_SIZE = 30;
    private static final String PASSWORD = "password";

    public static MessageIdManagerTestSystem createTestingData() {
        return new InMemoryMessageIdManagerTestSystem((MailboxManager)MessageIdManagerTestSystemProvider.createMailboxManager());
    }

    public static CombinationManagerTestSystem createManagersTestingData() {
        InMemoryMailboxManager mailboxManager = MessageIdManagerTestSystemProvider.createMailboxManager();
        return new InMemoryCombinationManagerTestSystem((MailboxManager)mailboxManager, (MessageIdManager)new InMemoryMessageIdManager((MailboxManager)mailboxManager));
    }

    private static InMemoryMailboxManager createMailboxManager() {
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        MessageParser messageParser = new MessageParser();
        InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        FakeAuthenticator authenticator = new FakeAuthenticator();
        FakeAuthorizator authorizator = FakeAuthorizator.defaultReject();
        authenticator.addUser("user", PASSWORD);
        authenticator.addUser("otheruser", PASSWORD);
        InMemoryMailboxManager mailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (Authenticator)authenticator, (Authorizator)authorizator, (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, messageParser, (MessageId.Factory)messageIdFactory, 3, 30);
        try {
            mailboxManager.init();
        }
        catch (MailboxException e) {
            Throwables.propagate((Throwable)e);
        }
        return mailboxManager;
    }
}

