/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.base.Throwables;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;

public class MemoryMailboxManagerProvider {
    private static final int LIMIT_ANNOTATIONS = 3;
    private static final int LIMIT_ANNOTATION_SIZE = 30;

    public static MailboxManager provideMailboxManager() {
        UnionMailboxACLResolver aclResolver = new UnionMailboxACLResolver();
        SimpleGroupMembershipResolver groupMembershipResolver = new SimpleGroupMembershipResolver();
        MessageParser messageParser = new MessageParser();
        InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        InMemoryMailboxManager mailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (Authenticator)new FakeAuthenticator(), (Authorizator)FakeAuthorizator.defaultReject(), (MailboxACLResolver)aclResolver, (GroupMembershipResolver)groupMembershipResolver, messageParser, (MessageId.Factory)messageIdFactory, 3, 30);
        try {
            mailboxManager.init();
        }
        catch (MailboxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return mailboxManager;
    }
}

