/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.InMemoryMessageIdManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MessageIdManagerTestSystem;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;

public class InMemoryMessageIdManagerTestSystem
extends MessageIdManagerTestSystem {
    private static final MessageId FIRST_MESSAGE_ID = InMemoryMessageId.of((long)1L);
    private static final long ONE_HUNDRED = 100L;
    private static final int UID_VALIDITY = 1024;
    private final MailboxManager mailboxManager;
    private Optional<MessageId> lastMessageIdUsed;

    public InMemoryMessageIdManagerTestSystem(MailboxManager mailboxManager) {
        super((MessageIdManager)new InMemoryMessageIdManager(mailboxManager));
        this.mailboxManager = mailboxManager;
        this.lastMessageIdUsed = Optional.absent();
    }

    public Mailbox createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
        this.mailboxManager.createMailbox(mailboxPath, mailboxSession);
        MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, mailboxSession);
        return new SimpleMailbox(mailboxPath, 1024L, messageManager.getId());
    }

    public MessageId persist(MailboxId mailboxId, MessageUid uid, Flags flags, MailboxSession session) {
        try {
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxId, session);
            MessageId messageId = messageManager.appendMessage((InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), session, false, flags).getMessageId();
            this.lastMessageIdUsed = Optional.of((Object)messageId);
            return messageId;
        }
        catch (MailboxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public MessageId createNotUsedMessageId() {
        return InMemoryMessageId.of((long)(Long.valueOf(((MessageId)this.lastMessageIdUsed.or((Object)FIRST_MESSAGE_ID)).serialize()) + 100L));
    }

    public void deleteMailbox(MailboxId mailboxId, MailboxSession session) {
        try {
            Optional<MailboxMetaData> mailbox = this.retrieveMailbox(mailboxId, session);
            if (mailbox.isPresent()) {
                this.mailboxManager.deleteMailbox(((MailboxMetaData)mailbox.get()).getPath(), session);
            }
        }
        catch (MailboxException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private Optional<MailboxMetaData> retrieveMailbox(final MailboxId mailboxId, MailboxSession mailboxSession) throws MailboxException {
        MailboxQuery userMailboxesQuery = MailboxQuery.builder((MailboxSession)mailboxSession).expression("*").build();
        return FluentIterable.from((Iterable)this.mailboxManager.search(userMailboxesQuery, mailboxSession)).filter((Predicate)new Predicate<MailboxMetaData>(){

            public boolean apply(MailboxMetaData mailboxMetaData) {
                return mailboxMetaData.getId().equals(mailboxId);
            }
        }).first();
    }

    public void clean() {
    }
}

