/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxIdDeserializer;
import org.apache.james.mailbox.store.mail.model.MailboxIdDeserialisationException;
import org.apache.james.mailbox.store.mail.model.MailboxIdDeserializer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class InMemoryMailboxIdDeserializerTest {
    private static final String SERIALIZED_ID = "1234567890123";
    private static final String MALFORMED_SERIALIZED_ID = "aEZ";
    private static final InMemoryId IN_MEMORY_ID = InMemoryId.of((long)Long.valueOf("1234567890123"));
    private MailboxIdDeserializer mailboxIdDeserializer;

    @Before
    public void setUp() {
        this.mailboxIdDeserializer = new InMemoryMailboxIdDeserializer();
    }

    @Test
    public void deserializeShouldWork() throws MailboxIdDeserialisationException {
        Assertions.assertThat((Object)this.mailboxIdDeserializer.deserialize(SERIALIZED_ID)).isEqualTo((Object)IN_MEMORY_ID);
    }

    @Test(expected=MailboxIdDeserialisationException.class)
    public void deserializeShouldThrowOnMalformedData() throws MailboxIdDeserialisationException {
        this.mailboxIdDeserializer.deserialize(MALFORMED_SERIALIZED_ID);
    }
}

