/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.CombinationManagerTestSystem;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailbox;

public class InMemoryCombinationManagerTestSystem
extends CombinationManagerTestSystem {
    private static final int UID_VALIDITY = 1024;
    private final InMemoryMailboxManager inMemoryMailboxManager;

    public InMemoryCombinationManagerTestSystem(MailboxManager mailboxManager, MessageIdManager messageIdManager) {
        super(mailboxManager, messageIdManager);
        this.inMemoryMailboxManager = (InMemoryMailboxManager)mailboxManager;
    }

    public MessageManager createMessageManager(Mailbox mailbox, MailboxSession session) throws MailboxException {
        return this.inMemoryMailboxManager.createMessageManager(mailbox, session);
    }

    public Mailbox createMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        this.inMemoryMailboxManager.createMailbox(mailboxPath, session);
        MessageManager messageManager = this.inMemoryMailboxManager.getMailbox(mailboxPath, session);
        return new SimpleMailbox(mailboxPath, 1024L, messageManager.getId());
    }

    public void clean() {
    }
}

