/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MessageBuilder;
import org.apache.james.mailbox.store.MessageIdManagerTestSystem;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndexContract;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class LuceneMailboxMessageSearchIndexTest {
    static final long LIMIT = 100L;
    static final TestId TEST_ID_1 = TestId.of((long)0L);
    static final TestId TEST_ID_2 = TestId.of((long)1L);
    static final TestId TEST_ID_3 = TestId.of((long)2L);
    static final Username BOB = Username.of((String)"bob");
    Mailbox mailbox = new Mailbox(MailboxPath.forUser((Username)BOB, (String)"box"), UidValidity.of((long)18L), (MailboxId)TEST_ID_1);
    Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)BOB, (String)"box"), UidValidity.of((long)19L), (MailboxId)TEST_ID_2);
    Mailbox mailbox3 = new Mailbox(MailboxPath.forUser((Username)BOB, (String)"box"), UidValidity.of((long)12L), (MailboxId)TEST_ID_3);
    LuceneMessageSearchIndex index;
    MailboxSession session;
    static final String FROM_ADDRESS = "Harry <harry@example.org>";
    static final String SUBJECT_PART = "Mixed";
    static final String CUSTARD = "CUSTARD";
    static final String RHUBARD = "Rhubard";
    static final String BODY = "This is a simple email\r\n It has Rhubard.\r\nIt has CUSTARD.\r\nIt needs naught else.\r\n";
    MessageUid uid1;
    MessageUid uid2;
    MessageUid uid3;
    MessageUid uid4;
    MessageUid uid5;
    MessageId id1;
    MessageId id2;
    MessageId id3;
    MessageId id4;
    MessageId id5;

    LuceneMailboxMessageSearchIndexTest() {
    }

    protected boolean useLenient() {
        return true;
    }

    @BeforeEach
    void setUp() throws Exception {
        this.session = MailboxSessionUtil.create((Username)Username.of((String)"username"));
        TestMessageId.Factory factory = new TestMessageId.Factory();
        this.id1 = factory.generate();
        this.id2 = factory.generate();
        this.id3 = factory.generate();
        this.id4 = factory.generate();
        this.id5 = factory.generate();
        this.index = new LuceneMessageSearchIndex(null, (MailboxId.Factory)new TestId.Factory(), (Directory)new RAMDirectory(), true, this.useLenient(), (MessageId.Factory)factory, null);
        this.index.setEnableSuffixMatch(true);
        HashMap<String, String> headersSubject = new HashMap<String, String>();
        headersSubject.put("Subject", "test (fwd)");
        headersSubject.put("From", "test99 <test99@localhost>");
        headersSubject.put("To", "test2 <test2@localhost>, test3 <test3@localhost>");
        HashMap<String, String> headersTest = new HashMap<String, String>();
        headersTest.put("Test", "test");
        headersTest.put("From", "test1 <test1@localhost>");
        headersTest.put("To", "test3 <test3@localhost>, test4 <test4@localhost>");
        headersTest.put("Cc", "test21 <test21@localhost>, test6 <test6@foobar>");
        HashMap<String, String> headersTestSubject = new HashMap<String, String>();
        headersTestSubject.put("Test", "test");
        headersTestSubject.put("Subject", "test2");
        headersTestSubject.put("Date", "Thu, 14 Feb 1990 12:00:00 +0000 (GMT)");
        headersTestSubject.put("From", "test12 <test12@localhost>");
        headersTestSubject.put("Cc", "test211 <test21@localhost>, test6 <test6@foobar>");
        this.uid1 = MessageUid.of((long)1L);
        MessageBuilder builder1 = new MessageBuilder().headers(headersSubject).flags(new Flags(Flags.Flag.ANSWERED)).mailboxId(TEST_ID_1).uid(this.uid1).internalDate(new Date()).body("My Body".getBytes(StandardCharsets.UTF_8)).size(200);
        this.index.add(this.session, this.mailbox, builder1.build(this.id1)).block();
        this.uid2 = MessageUid.of((long)1L);
        MessageBuilder builder2 = new MessageBuilder().headers(headersSubject).flags(new Flags(Flags.Flag.ANSWERED)).mailboxId(TEST_ID_2).uid(this.uid2).internalDate(new Date()).body("My Body".getBytes(StandardCharsets.UTF_8)).size(20);
        this.index.add(this.session, this.mailbox2, builder2.build(this.id2)).block();
        this.uid3 = MessageUid.of((long)2L);
        Calendar cal = Calendar.getInstance();
        cal.set(1980, 2, 10);
        MessageBuilder builder3 = new MessageBuilder().headers(headersTest).flags(new Flags(Flags.Flag.DELETED)).mailboxId(TEST_ID_1).uid(this.uid3).internalDate(cal.getTime()).body("My Otherbody".getBytes(StandardCharsets.UTF_8)).size(20);
        this.index.add(this.session, this.mailbox, builder3.build(this.id3)).block();
        this.uid4 = MessageUid.of((long)3L);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(8000, 2, 10);
        MessageBuilder builder4 = new MessageBuilder().headers(headersTestSubject).flags(new Flags(Flags.Flag.DELETED)).mailboxId(TEST_ID_1).uid(this.uid4).internalDate(cal2.getTime()).body("My Otherbody2".getBytes(StandardCharsets.UTF_8)).size(20);
        this.index.add(this.session, this.mailbox, builder4.build(this.id4)).block();
        this.uid5 = MessageUid.of((long)10L);
        MessageBuilder builder = new MessageBuilder();
        builder.header("From", "test <user-from@domain.org>");
        builder.header("To", FROM_ADDRESS);
        builder.header("Subject", "A Mixed Multipart Mail");
        builder.header("Date", "Thu, 14 Feb 2008 12:00:00 +0000 (GMT)");
        builder.body(StandardCharsets.US_ASCII.encode(BODY).array());
        builder.uid(this.uid5);
        builder.mailboxId(TEST_ID_3);
        this.index.add(this.session, this.mailbox3, builder.build(this.id5)).block();
    }

    @Test
    void bodySearchShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)CUSTARD)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void bodySearchShouldNotMatchAbsentPhraseInBody() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)"CUSTARDCUSTARD")});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).isEmpty();
    }

    @Test
    void bodySearchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)RHUBARD)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void bodySearchNotMatchPhraseOnlyInFrom() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)FROM_ADDRESS)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).isEmpty();
    }

    @Test
    void bodySearchShouldNotMatchPhraseOnlyInSubject() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)SUBJECT_PART)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).isEmpty();
    }

    @Test
    void textSearchShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)CUSTARD)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void textSearchShouldNotAbsentMatchPhraseInBody() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)"CUSTARDCUSTARD")});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).isEmpty();
    }

    @Test
    void textSearchMatchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)RHUBARD.toLowerCase(Locale.US))});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void addressSearchShouldMatchToFullAddress() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)FROM_ADDRESS)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void addressSearchShouldMatchToDisplayName() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry")});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void addressSearchShouldMatchToEmail() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry@example.org")});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void addressSearchShouldMatchFrom() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)"ser-from@domain.or")});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void textSearchShouldMatchPhraseOnlyInToHeader() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)FROM_ADDRESS)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void textSearchShouldMatchPhraseOnlyInSubjectHeader() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)SUBJECT_PART)});
        Stream result = this.index.search(this.session, this.mailbox3, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    void searchAllShouldMatchAllMailboxEmails() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()});
        Stream result = this.index.search(this.session, this.mailbox2, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid2});
    }

    @Test
    void searchBodyInAllMailboxesShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)"My Body")});
        List result = (List)this.index.search(this.session, (Collection)ImmutableList.of((Object)this.mailbox.getMailboxId(), (Object)this.mailbox2.getMailboxId(), (Object)this.mailbox3.getMailboxId()), query, 100L).collectList().block();
        Assertions.assertThat((List)result).containsOnly((Object[])new MessageId[]{this.id1, this.id2});
    }

    @Test
    void searchBodyInSpecificMailboxesShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)"My Body")});
        List result = (List)this.index.search(this.session, (Collection)ImmutableList.of((Object)this.mailbox.getMailboxId(), (Object)this.mailbox3.getMailboxId()), query, 100L).collectList().block();
        Assertions.assertThat((List)result).containsOnly((Object[])new MessageId[]{this.id1});
    }

    @Test
    void searchAllShouldMatchAllUserEmails() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()});
        List result = (List)this.index.search(this.session, (Collection)ImmutableList.of((Object)this.mailbox.getMailboxId(), (Object)this.mailbox2.getMailboxId(), (Object)this.mailbox3.getMailboxId()), query, 100L).collectList().block();
        Assertions.assertThat((List)result).hasSize(5);
    }

    @Test
    void searchAllShouldLimitTheSize() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()});
        int limit = 1;
        List result = (List)this.index.search(this.session, (Collection)ImmutableList.of((Object)this.mailbox.getMailboxId(), (Object)this.mailbox2.getMailboxId(), (Object)this.mailbox3.getMailboxId()), query, (long)limit).collectList().block();
        Assertions.assertThat((List)result).hasSize(limit);
    }

    @Test
    void flagSearchShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    @Test
    void bodySearchShouldMatchSeveralEmails() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.bodyContains((String)"body")});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void textSearchShouldMatchSeveralEmails() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mailContains((String)"body")});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void headerSearchShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.headerContains((String)"Subject", (String)"test")});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4});
    }

    @Test
    void headerExistsShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.headerExists((String)"Subject")});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4});
    }

    @Test
    void flagUnsetShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void internalDateBeforeShouldMatch() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.internalDateBefore((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3});
    }

    @Test
    void internalDateAfterShouldMatch() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.internalDateAfter((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid4});
    }

    @Test
    void internalDateOnShouldMatch() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.internalDateOn((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    void uidSearchShouldMatch() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1)})});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    void uidRangeSearchShouldMatch() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1), new SearchQuery.UidRange(this.uid3, this.uid4)})});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void sizeEqualsShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.sizeEquals((long)200L)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    void sizeLessThanShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.sizeLessThan((long)200L)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    @Test
    void sizeGreaterThanShouldMatch() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.sizeGreaterThan((long)6L)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void uidShouldBeSorted() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void uidReverseSortShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Uid, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid3, this.uid1});
    }

    @Test
    void sortOnSentDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    void reverseSortOnSentDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4, this.uid3});
    }

    @Test
    void sortOnSubjectShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    void reverseSortOnSubjectShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    void sortOnMailboxFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    void reverseSortOnMailboxFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4, this.uid3});
    }

    @Test
    void sortOnMailboxCCShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void reverseSortOnMailboxCCShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    void sortOnMailboxToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    void reverseSortOnMailboxToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    void sortOnArrivalDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    void reverseSortOnArrivalDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    void sortOnSizeShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, SearchQuery.Sort.Order.NATURAL)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    void reverseSortOnSizeShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = SearchQuery.allSortedWith((SearchQuery.Sort[])new SearchQuery.Sort[]{new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, SearchQuery.Sort.Order.REVERSE)});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    void notOperatorShouldReverseMatching() throws Exception {
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.not((SearchQuery.Criterion)SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1)}))});
        Stream result = this.index.search(this.session, this.mailbox, query).toStream();
        Assertions.assertThat((Stream)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    @Test
    void updateShouldUpdateFlags() throws Exception {
        Flags newFlags = new Flags(Flags.Flag.DRAFT);
        UpdatedFlags updatedFlags = UpdatedFlags.builder().uid(this.uid2).modSeq(MessageIdManagerTestSystem.MOD_SEQ).oldFlags(new Flags(Flags.Flag.ANSWERED)).newFlags(newFlags).build();
        this.index.update(this.session, this.mailbox.getMailboxId(), (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags})).block();
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT)});
        Assertions.assertThat((Stream)this.index.search(this.session, this.mailbox, query).toStream()).containsExactly((Object[])new MessageUid[]{this.uid2});
    }

    @Test
    void updateShouldNotUpdateNorThrowOnUnknownMessageUid() throws Exception {
        Flags newFlags = new Flags(Flags.Flag.DRAFT);
        UpdatedFlags updatedFlags = UpdatedFlags.builder().uid(MessageUid.of((long)42L)).modSeq(MessageIdManagerTestSystem.MOD_SEQ).oldFlags(new Flags()).newFlags(newFlags).build();
        this.index.update(this.session, this.mailbox.getMailboxId(), (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags})).block();
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT)});
        Assertions.assertThat((Stream)this.index.search(this.session, this.mailbox, query).toStream()).isEmpty();
    }

    @Test
    void updateShouldBeIdempotent() throws Exception {
        Flags newFlags = new Flags(Flags.Flag.DRAFT);
        UpdatedFlags updatedFlags = UpdatedFlags.builder().uid(this.uid2).modSeq(MessageIdManagerTestSystem.MOD_SEQ).oldFlags(new Flags()).newFlags(newFlags).build();
        this.index.update(this.session, this.mailbox.getMailboxId(), (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags})).block();
        this.index.update(this.session, this.mailbox.getMailboxId(), (List)Lists.newArrayList((Object[])new UpdatedFlags[]{updatedFlags})).block();
        SearchQuery query = SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT)});
        Assertions.assertThat((Stream)this.index.search(this.session, this.mailbox, query).toStream()).containsExactly((Object[])new MessageUid[]{this.uid2});
    }

    @Nested
    class RetrieveIndexedFlags
    implements ListeningMessageSearchIndexContract {
        RetrieveIndexedFlags() {
        }

        public ListeningMessageSearchIndex testee() {
            return LuceneMailboxMessageSearchIndexTest.this.index;
        }

        public MailboxSession session() {
            return LuceneMailboxMessageSearchIndexTest.this.session;
        }

        public Mailbox mailbox() {
            return LuceneMailboxMessageSearchIndexTest.this.mailbox;
        }
    }
}

