/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.InVMEventBus;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.delivery.EventDelivery;
import org.apache.james.mailbox.events.delivery.InVmEventDelivery;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProvider;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.AbstractMessageSearchIndexTest;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Ignore;

public class LuceneMessageSearchIndexTest
extends AbstractMessageSearchIndexTest {
    protected void await() {
    }

    protected void initializeMailboxManager() throws Exception {
        FakeAuthenticator fakeAuthenticator = new FakeAuthenticator();
        fakeAuthenticator.addUser("user@domain.org", "pass");
        fakeAuthenticator.addUser("otherUser@domain.org", "otherPass");
        InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
        InVMEventBus eventBus = new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new NoopMetricFactory()));
        StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (MailboxACLResolver)new UnionMailboxACLResolver(), (GroupMembershipResolver)new SimpleGroupMembershipResolver(), (EventBus)eventBus);
        StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, storeRightManager);
        SessionProvider sessionProvider = new SessionProvider((Authenticator)fakeAuthenticator, (Authorizator)FakeAuthorizator.defaultReject());
        QuotaComponents quotaComponents = QuotaComponents.disabled((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mailboxSessionMapperFactory);
        InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
        LuceneMessageSearchIndex luceneMessageSearchIndex = new LuceneMessageSearchIndex((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (MailboxId.Factory)new InMemoryId.Factory(), (Directory)new RAMDirectory(), (MessageId.Factory)messageIdFactory, new SessionProvider((Authenticator)new FakeAuthenticator(), (Authorizator)FakeAuthorizator.defaultReject()));
        this.storeMailboxManager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, sessionProvider, (MailboxPathLocker)new JVMMailboxPathLocker(), new MessageParser(), (MessageId.Factory)messageIdFactory, (EventBus)eventBus, annotationManager, storeRightManager, quotaComponents, (MessageSearchIndex)luceneMessageSearchIndex);
        this.messageIdManager = new StoreMessageIdManager((MailboxManager)this.storeMailboxManager, this.storeMailboxManager.getMapperFactory(), (EventBus)eventBus, this.storeMailboxManager.getMessageIdFactory(), quotaComponents.getQuotaManager(), quotaComponents.getQuotaRootResolver());
        eventBus.register((MailboxListener.GroupMailboxListener)luceneMessageSearchIndex);
        this.messageSearchIndex = luceneMessageSearchIndex;
    }

    @Ignore
    public void uidShouldreturnEveryThing() throws Exception {
    }

    @Ignore
    public void sortOnCcShouldWork() throws Exception {
    }

    @Ignore
    public void sortOnFromShouldWork() throws Exception {
    }

    @Ignore
    public void orShouldReturnResultsMatchinganyRequests() throws Exception {
    }

    @Ignore
    public void internalDateBeforeShouldReturnMessagesBeforeAGivenDate() throws Exception {
    }

    @Ignore
    public void internalDateAfterShouldReturnMessagesAfterAGivenDate() throws Exception {
    }

    @Ignore
    public void youShouldBeAbleToSpecifySeveralCriterionOnASingleQuery() throws Exception {
    }

    @Ignore
    public void modSeqLessThanShouldReturnUidsOfMessageHavingAGreaterModSeq() throws Exception {
    }

    @Ignore
    public void andShouldReturnResultsMatchingBothRequests() throws Exception {
    }

    @Ignore
    public void addressShouldReturnUidHavingRightExpeditorWhenFromIsSpecified() throws Exception {
    }

    @Ignore
    public void bodyContainsShouldReturnUidOfMessageContainingTheApproximativeText() throws MailboxException {
    }

    @Ignore
    public void sortOnDisplayFromShouldWork() throws Exception {
    }

    @Ignore
    public void mailsContainsShouldIncludeMailHavingAttachmentsMatchingTheRequest() throws Exception {
    }

    @Ignore
    public void modSeqGreaterThanShouldReturnUidsOfMessageHavingAGreaterModSeq() throws Exception {
    }

    @Ignore
    public void modSeqEqualsShouldReturnUidsOfMessageHavingAGivenModSeq() throws Exception {
    }

    @Ignore
    public void multimailboxSearchShouldReturnUidOfMessageMarkedAsSeenInTwoMailboxes() throws MailboxException {
    }

    @Ignore
    public void multimailboxSearchShouldReturnUidOfMessageMarkedAsSeenInAllMailboxes() throws MailboxException {
    }

    @Ignore(value="Lucene implementation is not handling mail addresses with names")
    public void sortOnToShouldWork() {
    }
}

