/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.store.MessageBuilder;
import org.apache.james.mailbox.store.SimpleMailboxMembership;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class LuceneMailboxMessageSearchIndexTest {
    public static final long LIMIT = 100L;
    private LuceneMessageSearchIndex index;
    private SimpleMailbox mailbox = new SimpleMailbox(0L);
    private SimpleMailbox mailbox2 = new SimpleMailbox(1L);
    private SimpleMailbox mailbox3 = new SimpleMailbox(2L);
    private MailboxSession session;
    private static final String FROM_ADDRESS = "Harry <harry@example.org>";
    private static final String SUBJECT_PART = "Mixed";
    private static final String CUSTARD = "CUSTARD";
    private static final String RHUBARD = "Rhubard";
    private static final String BODY = "This is a simple email\r\n It has Rhubard.\r\nIt has CUSTARD.\r\nIt needs naught else.\r\n";
    private MessageUid uid1;
    private MessageUid uid2;
    private MessageUid uid3;
    private MessageUid uid4;
    private MessageUid uid5;
    private MessageId id1;
    private MessageId id2;
    private MessageId id3;
    private MessageId id4;
    private MessageId id5;

    protected boolean useLenient() {
        return true;
    }

    @Before
    public void setUp() throws Exception {
        this.session = new MockMailboxSession("username");
        TestMessageId.Factory factory = new TestMessageId.Factory();
        this.id1 = factory.generate();
        this.id2 = factory.generate();
        this.id3 = factory.generate();
        this.id4 = factory.generate();
        this.id5 = factory.generate();
        this.index = new LuceneMessageSearchIndex(null, (MailboxId.Factory)new TestId.Factory(), (Directory)new RAMDirectory(), true, this.useLenient(), (MessageId.Factory)factory);
        this.index.setEnableSuffixMatch(true);
        HashMap<String, String> headersSubject = new HashMap<String, String>();
        headersSubject.put("Subject", "test (fwd)");
        headersSubject.put("From", "test99 <test99@localhost>");
        headersSubject.put("To", "test2 <test2@localhost>, test3 <test3@localhost>");
        HashMap<String, String> headersTest = new HashMap<String, String>();
        headersTest.put("Test", "test");
        headersTest.put("From", "test1 <test1@localhost>");
        headersTest.put("To", "test3 <test3@localhost>, test4 <test4@localhost>");
        headersTest.put("Cc", "test21 <test21@localhost>, test6 <test6@foobar>");
        HashMap<String, String> headersTestSubject = new HashMap<String, String>();
        headersTestSubject.put("Test", "test");
        headersTestSubject.put("Subject", "test2");
        headersTestSubject.put("Date", "Thu, 14 Feb 1990 12:00:00 +0000 (GMT)");
        headersTestSubject.put("From", "test12 <test12@localhost>");
        headersTestSubject.put("Cc", "test211 <test21@localhost>, test6 <test6@foobar>");
        this.uid1 = MessageUid.of((long)1L);
        SimpleMailboxMembership m = new SimpleMailboxMembership(this.id1, this.mailbox.getMailboxId(), this.uid1, 0L, new Date(), 200, new Flags(Flags.Flag.ANSWERED), "My Body".getBytes(), headersSubject);
        this.index.add(this.session, (Mailbox)this.mailbox, (MailboxMessage)m);
        this.uid2 = MessageUid.of((long)1L);
        SimpleMailboxMembership m2 = new SimpleMailboxMembership(this.id2, this.mailbox2.getMailboxId(), this.uid2, 0L, new Date(), 20, new Flags(Flags.Flag.ANSWERED), "My Body".getBytes(), headersSubject);
        this.index.add(this.session, (Mailbox)this.mailbox2, (MailboxMessage)m2);
        this.uid3 = MessageUid.of((long)2L);
        Calendar cal = Calendar.getInstance();
        cal.set(1980, 2, 10);
        SimpleMailboxMembership m3 = new SimpleMailboxMembership(this.id3, this.mailbox.getMailboxId(), this.uid3, 0L, cal.getTime(), 20, new Flags(Flags.Flag.DELETED), "My Otherbody".getBytes(), headersTest);
        this.index.add(this.session, (Mailbox)this.mailbox, (MailboxMessage)m3);
        this.uid4 = MessageUid.of((long)3L);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(8000, 2, 10);
        SimpleMailboxMembership m4 = new SimpleMailboxMembership(this.id4, this.mailbox.getMailboxId(), this.uid4, 0L, cal2.getTime(), 20, new Flags(Flags.Flag.DELETED), "My Otherbody2".getBytes(), headersTestSubject);
        this.index.add(this.session, (Mailbox)this.mailbox, (MailboxMessage)m4);
        this.uid5 = MessageUid.of((long)10L);
        MessageBuilder builder = new MessageBuilder();
        builder.header("From", "test <user-from@domain.org>");
        builder.header("To", FROM_ADDRESS);
        builder.header("Subject", "A Mixed Multipart Mail");
        builder.header("Date", "Thu, 14 Feb 2008 12:00:00 +0000 (GMT)");
        builder.body = Charset.forName("us-ascii").encode(BODY).array();
        builder.uid = this.uid5;
        builder.mailboxId = this.mailbox3.getMailboxId();
        this.index.add(this.session, (Mailbox)this.mailbox3, builder.build(this.id5));
    }

    @Test
    public void bodySearchShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)CUSTARD));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void bodySearchShouldNotMatchAbsentPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)"CUSTARDCUSTARD"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).isEmpty();
    }

    @Test
    public void bodySearchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)RHUBARD));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void bodySearchNotMatchPhraseOnlyInFrom() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)FROM_ADDRESS));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).isEmpty();
    }

    @Test
    public void bodySearchShouldNotMatchPhraseOnlyInSubject() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)SUBJECT_PART));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).isEmpty();
    }

    @Test
    public void textSearchShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)CUSTARD));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void textSearchShouldNotAbsentMatchPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)"CUSTARDCUSTARD"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).isEmpty();
    }

    @Test
    public void textSearchMatchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)RHUBARD.toLowerCase(Locale.US)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void addressSearchShouldMatchToFullAddress() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)FROM_ADDRESS));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void addressSearchShouldMatchToDisplayName() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void addressSearchShouldMatchToEmail() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry@example.org"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void addressSearchShouldMatchFrom() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)"ser-from@domain.or"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void textSearchShouldMatchPhraseOnlyInToHeader() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)FROM_ADDRESS));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void textSearchShouldMatchPhraseOnlyInSubjectHeader() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)SUBJECT_PART));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox3, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid5});
    }

    @Test
    public void searchAllShouldMatchAllMailboxEmails() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.all());
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox2, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid2});
    }

    @Test
    public void searchBodyInAllMailboxesShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)"My Body"));
        List result = this.index.search(this.session, MultimailboxesSearchQuery.from((SearchQuery)query).build(), 100L);
        Assertions.assertThat((List)result).containsOnly((Object[])new MessageId[]{this.id1, this.id2});
    }

    @Test
    public void searchBodyInSpecificMailboxesShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)"My Body"));
        List result = this.index.search(this.session, MultimailboxesSearchQuery.from((SearchQuery)query).inMailboxes(new MailboxId[]{this.mailbox.id, this.mailbox3.id}).build(), 100L);
        Assertions.assertThat((List)result).containsOnly((Object[])new MessageId[]{this.id1});
    }

    @Test
    public void searchAllShouldMatchAllUserEmails() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.all());
        List result = this.index.search(this.session, MultimailboxesSearchQuery.from((SearchQuery)query).build(), 100L);
        Assertions.assertThat((List)result).hasSize(5);
    }

    @Test
    public void searchAllShouldLimitTheSize() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.all());
        int limit = 1;
        List result = this.index.search(this.session, MultimailboxesSearchQuery.from((SearchQuery)query).build(), (long)limit);
        Assertions.assertThat((List)result).hasSize(limit);
    }

    @Test
    public void flagSearchShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    @Test
    public void bodySearchShouldMatchSeveralEmails() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)"body"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void textSearchShouldMatchSeveralEmails() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)"body"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void headerSearchShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.headerContains((String)"Subject", (String)"test"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4});
    }

    @Test
    public void headerExistsShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.headerExists((String)"Subject"));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4});
    }

    @Test
    public void flagUnsetShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void internalDateBeforeShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        query.andCriteria(SearchQuery.internalDateBefore((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3});
    }

    @Test
    public void internalDateAfterShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        query.andCriteria(SearchQuery.internalDateAfter((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4});
    }

    @Test
    public void internalDateOnShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        query.andCriteria(SearchQuery.internalDateOn((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    public void uidSearchShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        query.andCriteria(SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1)}));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    public void uidRangeSearchShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        query.andCriteria(SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1), new SearchQuery.UidRange(this.uid3, this.uid4)}));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void sizeEqualsShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.sizeEquals((long)200L));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1});
    }

    @Test
    public void sizeLessThanShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.sizeLessThan((long)200L));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    @Test
    public void sizeGreaterThanShouldMatch() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.sizeGreaterThan((long)6L));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void uidShouldBeSorted() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.all());
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void uidReverseSortShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.Uid, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid3, this.uid1});
    }

    @Test
    public void sortOnSentDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    public void reverseSortOnSentDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4, this.uid3});
    }

    @Test
    public void sortOnSubjectShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    public void reverseSortOnSubjectShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    public void sortOnMailboxFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    public void reverseSortOnMailboxFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4, this.uid3});
    }

    @Test
    public void sortOnMailboxCCShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void reverseSortOnMailboxCCShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    public void sortOnMailboxToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    public void reverseSortOnMailboxToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    public void sortOnDisplayToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayTo, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    public void reverseSortOnDisplayToShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayTo, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    public void sortOnDisplayFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayFrom, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    public void reverseSortOnDisplayFromShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayFrom, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid4, this.uid3});
    }

    @Test
    public void sortOnArrivalDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid1, this.uid4});
    }

    @Test
    public void reverseSortOnArrivalDateShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid4, this.uid1, this.uid3});
    }

    @Test
    public void sortOnSizeShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, SearchQuery.Sort.Order.NATURAL)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4, this.uid1});
    }

    @Test
    public void reverseSortOnSizeShouldReturnWellOrderedResults() throws Exception {
        SearchQuery query = new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()});
        query.setSorts((List)ImmutableList.of((Object)new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, SearchQuery.Sort.Order.REVERSE)));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid1, this.uid3, this.uid4});
    }

    @Test
    public void notOperatorShouldReverseMatching() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.not((SearchQuery.Criterion)SearchQuery.uid((SearchQuery.UidRange[])new SearchQuery.UidRange[]{new SearchQuery.UidRange(this.uid1)})));
        Iterator result = this.index.search(this.session, (Mailbox)this.mailbox, query);
        Assertions.assertThat((Iterator)result).containsExactly((Object[])new MessageUid[]{this.uid3, this.uid4});
    }

    private final class SimpleMailbox
    implements Mailbox {
        private final TestId id;

        public SimpleMailbox(long id) {
            this.id = TestId.of((long)id);
        }

        public void setMailboxId(MailboxId id) {
        }

        public MailboxPath generateAssociatedPath() {
            return new MailboxPath(this.getNamespace(), this.getUser(), this.getName());
        }

        public TestId getMailboxId() {
            return this.id;
        }

        public String getNamespace() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void setNamespace(String namespace) {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getUser() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void setUser(String user) {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getName() {
            return this.id.serialize();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Not supported");
        }

        public long getUidValidity() {
            return 0L;
        }

        public MailboxACL getACL() {
            return SimpleMailboxACL.OWNER_FULL_ACL;
        }

        public void setACL(MailboxACL acl) {
            throw new UnsupportedOperationException("Not supported");
        }

        public boolean isChildOf(Mailbox potentialParent, MailboxSession mailboxSession) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

