/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedSearchException;
import org.apache.james.mailbox.lucene.search.LenientImapSearchAnalyzer;
import org.apache.james.mailbox.lucene.search.StrictImapSearchAnalyzer;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.datetime.DateTime;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.address.AddressFormatter;
import org.apache.james.mime4j.field.address.LenientAddressBuilder;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.mime4j.message.SimpleContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class LuceneMessageSearchIndex<Id>
extends ListeningMessageSearchIndex<Id> {
    private static final Date MAX_DATE;
    private static final Date MIN_DATE;
    public static final int DEFAULT_MAX_QUERY_RESULTS = 100000;
    public static final String ID_FIELD = "id";
    public static final String UID_FIELD = "uid";
    public static final String FLAGS_FIELD = "flags";
    public static final String SIZE_FIELD = "size";
    public static final String BODY_FIELD = "body";
    public static final String PREFIX_HEADER_FIELD = "header_";
    public static final String HEADERS_FIELD = "headers";
    public static final String MODSEQ_FIELD = "modSeq";
    public static final String TO_FIELD = "to";
    public static final String FIRST_TO_MAILBOX_NAME_FIELD = "firstToMailboxName";
    public static final String FIRST_TO_MAILBOX_DISPLAY_FIELD = "firstToMailboxDisplay";
    public static final String CC_FIELD = "cc";
    public static final String FIRST_CC_MAILBOX_NAME_FIELD = "firstCcMailboxName";
    public static final String FROM_FIELD = "from";
    public static final String FIRST_FROM_MAILBOX_NAME_FIELD = "firstFromMailboxName";
    public static final String FIRST_FROM_MAILBOX_DISPLAY_FIELD = "firstFromMailboxDisplay";
    public static final String BCC_FIELD = "bcc";
    public static final String BASE_SUBJECT_FIELD = "baseSubject";
    public static final String INTERNAL_DATE_FIELD_YEAR_RESOLUTION = "internaldateYearResolution";
    public static final String INTERNAL_DATE_FIELD_MONTH_RESOLUTION = "internaldateMonthResolution";
    public static final String INTERNAL_DATE_FIELD_DAY_RESOLUTION = "internaldateDayResolution";
    public static final String INTERNAL_DATE_FIELD_HOUR_RESOLUTION = "internaldateHourResolution";
    public static final String INTERNAL_DATE_FIELD_MINUTE_RESOLUTION = "internaldateMinuteResolution";
    public static final String INTERNAL_DATE_FIELD_SECOND_RESOLUTION = "internaldateSecondResolution";
    public static final String INTERNAL_DATE_FIELD_MILLISECOND_RESOLUTION = "internaldateMillisecondResolution";
    public static final String MAILBOX_ID_FIELD = "mailboxid";
    public static final String SENT_DATE_FIELD_YEAR_RESOLUTION = "sentdateYearResolution";
    public static final String SENT_DATE_FIELD_MONTH_RESOLUTION = "sentdateMonthResolution";
    public static final String SENT_DATE_FIELD_DAY_RESOLUTION = "sentdateDayResolution";
    public static final String SENT_DATE_FIELD_HOUR_RESOLUTION = "sentdateHourResolution";
    public static final String SENT_DATE_FIELD_MINUTE_RESOLUTION = "sentdateMinuteResolution";
    public static final String SENT_DATE_FIELD_SECOND_RESOLUTION = "sentdateSecondResolution";
    public static final String SENT_DATE_FIELD_MILLISECOND_RESOLUTION = "sentdateMillisecondResolution";
    public static final String SENT_DATE_SORT_FIELD_MILLISECOND_RESOLUTION = "sentdateSort";
    public static final String NON_EXIST_FIELD = "nonExistField";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private final IndexWriter writer;
    private int maxQueryResults = 100000;
    private boolean suffixMatch = false;
    private static final SortField UID_SORT;
    private static final SortField UID_SORT_REVERSE;
    private static final SortField SIZE_SORT;
    private static final SortField SIZE_SORT_REVERSE;
    private static final SortField FIRST_CC_MAILBOX_SORT;
    private static final SortField FIRST_CC_MAILBOX_SORT_REVERSE;
    private static final SortField FIRST_TO_MAILBOX_SORT;
    private static final SortField FIRST_TO_MAILBOX_SORT_REVERSE;
    private static final SortField FIRST_FROM_MAILBOX_SORT;
    private static final SortField FIRST_FROM_MAILBOX_SORT_REVERSE;
    private static final SortField ARRIVAL_MAILBOX_SORT;
    private static final SortField ARRIVAL_MAILBOX_SORT_REVERSE;
    private static final SortField BASE_SUBJECT_SORT;
    private static final SortField BASE_SUBJECT_SORT_REVERSE;
    private static final SortField SENT_DATE_SORT;
    private static final SortField SENT_DATE_SORT_REVERSE;
    private static final SortField FIRST_TO_MAILBOX_DISPLAY_SORT;
    private static final SortField FIRST_TO_MAILBOX_DISPLAY_SORT_REVERSE;
    private static final SortField FIRST_FROM_MAILBOX_DISPLAY_SORT;
    private static final SortField FIRST_FROM_MAILBOX_DISPLAY_SORT_REVERSE;

    public LuceneMessageSearchIndex(MessageMapperFactory<Id> factory, Directory directory) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(factory, directory, false, true);
    }

    public LuceneMessageSearchIndex(MessageMapperFactory<Id> factory, Directory directory, boolean dropIndexOnStart, boolean lenient) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(factory);
        this.writer = new IndexWriter(directory, this.createConfig(this.createAnalyzer(lenient), dropIndexOnStart));
    }

    public LuceneMessageSearchIndex(MessageMapperFactory<Id> factory, IndexWriter writer) {
        super(factory);
        this.writer = writer;
    }

    public void setMaxQueryResults(int maxQueryResults) {
        this.maxQueryResults = maxQueryResults;
    }

    protected IndexWriterConfig createConfig(Analyzer analyzer, boolean dropIndexOnStart) {
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_31, analyzer);
        if (dropIndexOnStart) {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        return config;
    }

    protected Analyzer createAnalyzer(boolean lenient) {
        if (lenient) {
            return new LenientImapSearchAnalyzer();
        }
        return new StrictImapSearchAnalyzer();
    }

    public void setEnableSuffixMatch(boolean suffixMatch) {
        this.suffixMatch = suffixMatch;
    }

    public Iterator<Long> search(MailboxSession session, org.apache.james.mailbox.store.mail.model.Mailbox<Id> mailbox, SearchQuery searchQuery) throws MailboxException {
        LinkedHashSet<Long> uids = new LinkedHashSet<Long>();
        IndexSearcher searcher = null;
        try {
            searcher = new IndexSearcher(IndexReader.open((IndexWriter)this.writer, (boolean)true));
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term(MAILBOX_ID_FIELD, mailbox.getMailboxId().toString())), BooleanClause.Occur.MUST);
            query.add((Query)new PrefixQuery(new Term(FLAGS_FIELD, "")), BooleanClause.Occur.MUST_NOT);
            List crits = searchQuery.getCriterias();
            for (int i = 0; i < crits.size(); ++i) {
                query.add(this.createQuery((SearchQuery.Criterion)crits.get(i), mailbox, searchQuery.getRecentMessageUids()), BooleanClause.Occur.MUST);
            }
            TopFieldDocs docs = searcher.search((Query)query, null, this.maxQueryResults, this.createSort(searchQuery.getSorts()));
            ScoreDoc[] sDocs = docs.scoreDocs;
            for (int i = 0; i < sDocs.length; ++i) {
                long uid = Long.valueOf(searcher.doc(sDocs[i].doc).get(UID_FIELD));
                uids.add(uid);
            }
        }
        catch (IOException e) {
            throw new MailboxException("Unable to search the mailbox", (Exception)e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {}
            }
        }
        return uids.iterator();
    }

    private Document createMessageDocument(final MailboxSession session, final Message<?> membership) throws MailboxException {
        final Document doc = new Document();
        doc.add((Fieldable)new org.apache.lucene.document.Field(MAILBOX_ID_FIELD, membership.getMailboxId().toString().toUpperCase(Locale.ENGLISH), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField(UID_FIELD, Field.Store.YES, true).setLongValue(membership.getUid()));
        doc.add((Fieldable)new org.apache.lucene.document.Field(ID_FIELD, membership.getMailboxId().toString().toUpperCase(Locale.ENGLISH) + "-" + Long.toString(membership.getUid()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_YEAR_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_MONTH_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.MONTH), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_DAY_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_HOUR_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.HOUR), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_MINUTE_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_SECOND_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(INTERNAL_DATE_FIELD_MILLISECOND_RESOLUTION, DateTools.dateToString((Date)membership.getInternalDate(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField(SIZE_FIELD, Field.Store.YES, true).setLongValue(membership.getFullContentOctets()));
        SimpleContentHandler handler = new SimpleContentHandler(){

            public void headers(Header header) {
                Date sentDate = null;
                String firstFromMailbox = "";
                String firstToMailbox = "";
                String firstCcMailbox = "";
                String firstFromDisplay = "";
                String firstToDisplay = "";
                for (Field f : header) {
                    String headerName = f.getName().toUpperCase(Locale.ENGLISH);
                    String headerValue = f.getBody().toUpperCase(Locale.ENGLISH);
                    String fullValue = f.toString().toUpperCase(Locale.ENGLISH);
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.HEADERS_FIELD, fullValue, Field.Store.NO, Field.Index.ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.PREFIX_HEADER_FIELD + headerName, headerValue, Field.Store.NO, Field.Index.ANALYZED));
                    if (f instanceof DateTimeField) {
                        StringReader reader = new StringReader(f.getBody());
                        try {
                            DateTime dateTime = new DateTimeParser((Reader)reader).parseAll();
                            Calendar cal = LuceneMessageSearchIndex.getGMT();
                            cal.set(dateTime.getYear(), dateTime.getMonth() - 1, dateTime.getDay(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond());
                            sentDate = cal.getTime();
                        }
                        catch (ParseException e) {
                            session.getLog().debug("Unable to parse Date header for proper indexing", (Throwable)e);
                            sentDate = ((DateTimeField)f).getDate();
                        }
                    }
                    String field = null;
                    if ("To".equalsIgnoreCase(headerName)) {
                        field = LuceneMessageSearchIndex.TO_FIELD;
                    } else if ("From".equalsIgnoreCase(headerName)) {
                        field = LuceneMessageSearchIndex.FROM_FIELD;
                    } else if ("Cc".equalsIgnoreCase(headerName)) {
                        field = LuceneMessageSearchIndex.CC_FIELD;
                    } else if ("Bcc".equalsIgnoreCase(headerName)) {
                        field = LuceneMessageSearchIndex.BCC_FIELD;
                    }
                    if (field != null) {
                        AddressList aList = LenientAddressBuilder.DEFAULT.parseAddressList(MimeUtil.unfold((String)f.getBody()));
                        for (int i = 0; i < aList.size(); ++i) {
                            Address address = aList.get(i);
                            if (address instanceof Mailbox) {
                                Mailbox mailbox = (Mailbox)address;
                                String value = AddressFormatter.DEFAULT.encode(mailbox).toUpperCase(Locale.ENGLISH);
                                doc.add((Fieldable)new org.apache.lucene.document.Field(field, value, Field.Store.NO, Field.Index.ANALYZED));
                                if (i != 0) continue;
                                String mailboxAddress = SearchUtil.getMailboxAddress((Mailbox)mailbox);
                                String mailboxDisplay = SearchUtil.getDisplayAddress((Mailbox)mailbox);
                                if ("To".equalsIgnoreCase(headerName)) {
                                    firstToMailbox = mailboxAddress;
                                    firstToDisplay = mailboxDisplay;
                                    continue;
                                }
                                if ("From".equalsIgnoreCase(headerName)) {
                                    firstFromMailbox = mailboxAddress;
                                    firstFromDisplay = mailboxDisplay;
                                    continue;
                                }
                                if (!"Cc".equalsIgnoreCase(headerName)) continue;
                                firstCcMailbox = mailboxAddress;
                                continue;
                            }
                            if (!(address instanceof Group)) continue;
                            MailboxList mList = ((Group)address).getMailboxes();
                            for (int a = 0; a < mList.size(); ++a) {
                                Mailbox mailbox = mList.get(a);
                                String value = AddressFormatter.DEFAULT.encode(mailbox).toUpperCase(Locale.ENGLISH);
                                doc.add((Fieldable)new org.apache.lucene.document.Field(field, value, Field.Store.NO, Field.Index.ANALYZED));
                                if (i != 0 || a != 0) continue;
                                String mailboxAddress = SearchUtil.getMailboxAddress((Mailbox)mailbox);
                                String mailboxDisplay = SearchUtil.getDisplayAddress((Mailbox)mailbox);
                                if ("To".equalsIgnoreCase(headerName)) {
                                    firstToMailbox = mailboxAddress;
                                    firstToDisplay = mailboxDisplay;
                                    continue;
                                }
                                if ("From".equalsIgnoreCase(headerName)) {
                                    firstFromMailbox = mailboxAddress;
                                    firstFromDisplay = mailboxDisplay;
                                    continue;
                                }
                                if (!"Cc".equalsIgnoreCase(headerName)) continue;
                                firstCcMailbox = mailboxAddress;
                            }
                        }
                        doc.add((Fieldable)new org.apache.lucene.document.Field(field, headerValue, Field.Store.NO, Field.Index.ANALYZED));
                        continue;
                    }
                    if (!headerName.equalsIgnoreCase("Subject")) continue;
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.BASE_SUBJECT_FIELD, SearchUtil.getBaseSubject((String)headerValue), Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                if (sentDate == null) {
                    sentDate = membership.getInternalDate();
                } else {
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_YEAR_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_MONTH_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MONTH), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_DAY_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_HOUR_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.HOUR), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_MINUTE_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_SECOND_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
                    doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_FIELD_MILLISECOND_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.SENT_DATE_SORT_FIELD_MILLISECOND_RESOLUTION, DateTools.dateToString((Date)sentDate, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.FIRST_FROM_MAILBOX_NAME_FIELD, firstFromMailbox, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.FIRST_TO_MAILBOX_NAME_FIELD, firstToMailbox, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.FIRST_CC_MAILBOX_NAME_FIELD, firstCcMailbox, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.FIRST_FROM_MAILBOX_DISPLAY_FIELD, firstFromDisplay, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.FIRST_TO_MAILBOX_DISPLAY_FIELD, firstToDisplay, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }

            public void body(BodyDescriptor desc, InputStream in) throws MimeException, IOException {
                String mediaType = desc.getMediaType();
                if (LuceneMessageSearchIndex.MEDIA_TYPE_TEXT.equalsIgnoreCase(mediaType) || LuceneMessageSearchIndex.MEDIA_TYPE_MESSAGE.equalsIgnoreCase(mediaType)) {
                    Charset charset;
                    String cset = desc.getCharset();
                    if (cset == null) {
                        cset = LuceneMessageSearchIndex.DEFAULT_ENCODING;
                    }
                    try {
                        charset = Charset.forName(cset);
                    }
                    catch (Exception e) {
                        charset = Charset.forName(LuceneMessageSearchIndex.DEFAULT_ENCODING);
                    }
                    BufferedReader bodyReader = new BufferedReader(new InputStreamReader(in, charset));
                    String line = null;
                    while ((line = bodyReader.readLine()) != null) {
                        doc.add((Fieldable)new org.apache.lucene.document.Field(LuceneMessageSearchIndex.BODY_FIELD, line.toUpperCase(Locale.ENGLISH), Field.Store.NO, Field.Index.ANALYZED));
                    }
                }
            }
        };
        MimeConfig config = new MimeConfig();
        config.setMaxLineLen(-1);
        config.setMaxContentLen(-1L);
        MimeStreamParser parser = new MimeStreamParser(config);
        parser.setContentDecoding(true);
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse(membership.getFullContent());
        }
        catch (MimeException e) {
            throw new MailboxException("Unable to index content of message", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to index content of message", (Exception)e);
        }
        return doc;
    }

    private String toSentDateField(SearchQuery.DateResolution res) {
        String field;
        switch (res) {
            case Year: {
                field = SENT_DATE_FIELD_YEAR_RESOLUTION;
                break;
            }
            case Month: {
                field = SENT_DATE_FIELD_MONTH_RESOLUTION;
                break;
            }
            case Day: {
                field = SENT_DATE_FIELD_DAY_RESOLUTION;
                break;
            }
            case Hour: {
                field = SENT_DATE_FIELD_HOUR_RESOLUTION;
                break;
            }
            case Minute: {
                field = SENT_DATE_FIELD_MINUTE_RESOLUTION;
                break;
            }
            case Second: {
                field = SENT_DATE_FIELD_SECOND_RESOLUTION;
                break;
            }
            default: {
                field = SENT_DATE_FIELD_MILLISECOND_RESOLUTION;
            }
        }
        return field;
    }

    private static Calendar getGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ENGLISH);
    }

    private String toInteralDateField(SearchQuery.DateResolution res) {
        String field;
        switch (res) {
            case Year: {
                field = INTERNAL_DATE_FIELD_YEAR_RESOLUTION;
                break;
            }
            case Month: {
                field = INTERNAL_DATE_FIELD_MONTH_RESOLUTION;
                break;
            }
            case Day: {
                field = INTERNAL_DATE_FIELD_DAY_RESOLUTION;
                break;
            }
            case Hour: {
                field = INTERNAL_DATE_FIELD_HOUR_RESOLUTION;
                break;
            }
            case Minute: {
                field = INTERNAL_DATE_FIELD_MINUTE_RESOLUTION;
                break;
            }
            case Second: {
                field = INTERNAL_DATE_FIELD_SECOND_RESOLUTION;
                break;
            }
            default: {
                field = INTERNAL_DATE_FIELD_MILLISECOND_RESOLUTION;
            }
        }
        return field;
    }

    private Query createInternalDateQuery(SearchQuery.InternalDateCriterion crit) throws UnsupportedSearchException {
        SearchQuery.DateOperator dop = crit.getOperator();
        SearchQuery.DateResolution res = dop.getDateResultion();
        String field = this.toInteralDateField(res);
        return this.createQuery(field, dop);
    }

    private Query createSizeQuery(SearchQuery.SizeCriterion crit) throws UnsupportedSearchException {
        SearchQuery.NumericOperator op = crit.getOperator();
        switch (op.getType()) {
            case EQUALS: {
                return NumericRangeQuery.newLongRange((String)SIZE_FIELD, (Long)op.getValue(), (Long)op.getValue(), (boolean)true, (boolean)true);
            }
            case GREATER_THAN: {
                return NumericRangeQuery.newLongRange((String)SIZE_FIELD, (Long)op.getValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true);
            }
            case LESS_THAN: {
                return NumericRangeQuery.newLongRange((String)SIZE_FIELD, (Long)Long.MIN_VALUE, (Long)op.getValue(), (boolean)true, (boolean)false);
            }
        }
        throw new UnsupportedSearchException();
    }

    private Query createTermQuery(String fieldName, String value) {
        if (this.suffixMatch) {
            return new WildcardQuery(new Term(fieldName, "*" + value + "*"));
        }
        return new PrefixQuery(new Term(fieldName, value));
    }

    private Query createHeaderQuery(SearchQuery.HeaderCriterion crit) throws UnsupportedSearchException {
        SearchQuery.HeaderOperator op = crit.getOperator();
        String name = crit.getHeaderName().toUpperCase(Locale.ENGLISH);
        String fieldName = PREFIX_HEADER_FIELD + name;
        if (op instanceof SearchQuery.ContainsOperator) {
            SearchQuery.ContainsOperator cop = (SearchQuery.ContainsOperator)op;
            return this.createTermQuery(fieldName, cop.getValue().toUpperCase(Locale.ENGLISH));
        }
        if (op instanceof SearchQuery.ExistsOperator) {
            return new PrefixQuery(new Term(fieldName, ""));
        }
        if (op instanceof SearchQuery.DateOperator) {
            SearchQuery.DateOperator dop = (SearchQuery.DateOperator)op;
            String field = this.toSentDateField(dop.getDateResultion());
            return this.createQuery(field, dop);
        }
        if (op instanceof SearchQuery.AddressOperator) {
            String field = name.toLowerCase(Locale.ENGLISH);
            return this.createTermQuery(field, ((SearchQuery.AddressOperator)op).getAddress().toUpperCase(Locale.ENGLISH));
        }
        throw new UnsupportedSearchException();
    }

    private Query createQuery(String field, SearchQuery.DateOperator dop) throws UnsupportedSearchException {
        Date date = dop.getDate();
        SearchQuery.DateResolution res = dop.getDateResultion();
        DateTools.Resolution dRes = this.toResolution(res);
        String value = DateTools.dateToString((Date)date, (DateTools.Resolution)dRes);
        switch (dop.getType()) {
            case ON: {
                return new TermQuery(new Term(field, value));
            }
            case BEFORE: {
                return new TermRangeQuery(field, DateTools.dateToString((Date)MIN_DATE, (DateTools.Resolution)dRes), value, true, false);
            }
            case AFTER: {
                return new TermRangeQuery(field, value, DateTools.dateToString((Date)MAX_DATE, (DateTools.Resolution)dRes), false, true);
            }
        }
        throw new UnsupportedSearchException();
    }

    private DateTools.Resolution toResolution(SearchQuery.DateResolution res) {
        switch (res) {
            case Year: {
                return DateTools.Resolution.YEAR;
            }
            case Month: {
                return DateTools.Resolution.MONTH;
            }
            case Day: {
                return DateTools.Resolution.DAY;
            }
            case Hour: {
                return DateTools.Resolution.HOUR;
            }
            case Minute: {
                return DateTools.Resolution.MINUTE;
            }
            case Second: {
                return DateTools.Resolution.SECOND;
            }
        }
        return DateTools.Resolution.MILLISECOND;
    }

    private Query createUidQuery(SearchQuery.UidCriterion crit) throws UnsupportedSearchException {
        SearchQuery.NumericRange[] ranges = crit.getOperator().getRange();
        if (ranges.length == 1) {
            SearchQuery.NumericRange range = ranges[0];
            return NumericRangeQuery.newLongRange((String)UID_FIELD, (Long)range.getLowValue(), (Long)range.getHighValue(), (boolean)true, (boolean)true);
        }
        BooleanQuery rangesQuery = new BooleanQuery();
        for (int i = 0; i < ranges.length; ++i) {
            SearchQuery.NumericRange range = ranges[i];
            rangesQuery.add((Query)NumericRangeQuery.newLongRange((String)UID_FIELD, (Long)range.getLowValue(), (Long)range.getHighValue(), (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
        }
        return rangesQuery;
    }

    private Query createModSeqQuery(SearchQuery.ModSeqCriterion crit) throws UnsupportedSearchException {
        SearchQuery.NumericOperator op = crit.getOperator();
        switch (op.getType()) {
            case EQUALS: {
                return NumericRangeQuery.newLongRange((String)MODSEQ_FIELD, (Long)op.getValue(), (Long)op.getValue(), (boolean)true, (boolean)true);
            }
            case GREATER_THAN: {
                return NumericRangeQuery.newLongRange((String)MODSEQ_FIELD, (Long)op.getValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true);
            }
            case LESS_THAN: {
                return NumericRangeQuery.newLongRange((String)MODSEQ_FIELD, (Long)Long.MIN_VALUE, (Long)op.getValue(), (boolean)true, (boolean)false);
            }
        }
        throw new UnsupportedSearchException();
    }

    private Query createFlagQuery(String flag, boolean isSet, org.apache.james.mailbox.store.mail.model.Mailbox<?> mailbox, Collection<Long> recentUids) throws MailboxException, UnsupportedSearchException {
        BooleanQuery query = new BooleanQuery();
        if (isSet) {
            query.add((Query)new TermQuery(new Term(FLAGS_FIELD, flag)), BooleanClause.Occur.MUST);
        } else {
            BooleanQuery bQuery = new BooleanQuery();
            bQuery.add((Query)new PrefixQuery(new Term(FLAGS_FIELD, "")), BooleanClause.Occur.MUST);
            bQuery.add((Query)new TermQuery(new Term(FLAGS_FIELD, flag)), BooleanClause.Occur.MUST_NOT);
            query.add((Query)bQuery, BooleanClause.Occur.MUST);
        }
        query.add((Query)new TermQuery(new Term(MAILBOX_ID_FIELD, mailbox.getMailboxId().toString())), BooleanClause.Occur.MUST);
        IndexSearcher searcher = null;
        try {
            HashSet<Long> uids = new HashSet<Long>();
            searcher = new IndexSearcher(IndexReader.open((IndexWriter)this.writer, (boolean)true));
            TopFieldDocs docs = searcher.search((Query)query, null, this.maxQueryResults, new Sort(UID_SORT));
            ScoreDoc[] sDocs = docs.scoreDocs;
            for (int i = 0; i < sDocs.length; ++i) {
                long uid = Long.valueOf(searcher.doc(sDocs[i].doc).get(UID_FIELD));
                uids.add(uid);
            }
            if (flag.equalsIgnoreCase("\\RECENT")) {
                if (isSet) {
                    uids.addAll(recentUids);
                } else {
                    uids.removeAll(recentUids);
                }
            }
            List ranges = MessageRange.toRanges(new ArrayList(uids));
            SearchQuery.NumericRange[] nRanges = new SearchQuery.NumericRange[ranges.size()];
            for (int i = 0; i < ranges.size(); ++i) {
                MessageRange range = (MessageRange)ranges.get(i);
                nRanges[i] = new SearchQuery.NumericRange(range.getUidFrom(), range.getUidTo());
            }
            Query query2 = this.createUidQuery((SearchQuery.UidCriterion)SearchQuery.uid((SearchQuery.NumericRange[])nRanges));
            return query2;
        }
        catch (IOException e) {
            throw new MailboxException("Unable to search mailbox " + mailbox, (Exception)e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Sort createSort(List<SearchQuery.Sort> sorts) {
        Sort sort = new Sort();
        ArrayList<SortField> fields = new ArrayList<SortField>();
        for (int i = 0; i < sorts.size(); ++i) {
            SearchQuery.Sort s = sorts.get(i);
            boolean reverse = s.isReverse();
            SortField sf = null;
            switch (s.getSortClause()) {
                case Arrival: {
                    if (reverse) {
                        sf = ARRIVAL_MAILBOX_SORT_REVERSE;
                        break;
                    }
                    sf = ARRIVAL_MAILBOX_SORT;
                    break;
                }
                case SentDate: {
                    if (reverse) {
                        sf = SENT_DATE_SORT_REVERSE;
                        break;
                    }
                    sf = SENT_DATE_SORT;
                    break;
                }
                case MailboxCc: {
                    if (reverse) {
                        sf = FIRST_CC_MAILBOX_SORT_REVERSE;
                        break;
                    }
                    sf = FIRST_CC_MAILBOX_SORT;
                    break;
                }
                case MailboxFrom: {
                    if (reverse) {
                        sf = FIRST_FROM_MAILBOX_SORT_REVERSE;
                        break;
                    }
                    sf = FIRST_FROM_MAILBOX_SORT;
                    break;
                }
                case Size: {
                    if (reverse) {
                        sf = SIZE_SORT_REVERSE;
                        break;
                    }
                    sf = SIZE_SORT;
                    break;
                }
                case BaseSubject: {
                    if (reverse) {
                        sf = BASE_SUBJECT_SORT_REVERSE;
                        break;
                    }
                    sf = BASE_SUBJECT_SORT;
                    break;
                }
                case MailboxTo: {
                    if (reverse) {
                        sf = FIRST_TO_MAILBOX_SORT_REVERSE;
                        break;
                    }
                    sf = FIRST_TO_MAILBOX_SORT;
                    break;
                }
                case Uid: {
                    if (reverse) {
                        sf = UID_SORT_REVERSE;
                        break;
                    }
                    sf = UID_SORT;
                    break;
                }
                case DisplayFrom: {
                    if (reverse) {
                        sf = FIRST_FROM_MAILBOX_DISPLAY_SORT_REVERSE;
                        break;
                    }
                    sf = FIRST_FROM_MAILBOX_DISPLAY_SORT;
                    break;
                }
                case DisplayTo: {
                    if (reverse) {
                        sf = FIRST_TO_MAILBOX_DISPLAY_SORT_REVERSE;
                        break;
                    }
                    sf = FIRST_TO_MAILBOX_DISPLAY_SORT;
                    break;
                }
            }
            if (sf == null) continue;
            fields.add(sf);
            if (sf == SENT_DATE_SORT) {
                fields.add(UID_SORT);
                continue;
            }
            if (sf != SENT_DATE_SORT_REVERSE) continue;
            fields.add(UID_SORT_REVERSE);
        }
        fields.add(UID_SORT);
        sort.setSort(fields.toArray(new SortField[0]));
        return sort;
    }

    private String toString(Flags.Flag flag) {
        if (Flags.Flag.ANSWERED.equals(flag)) {
            return "\\ANSWERED";
        }
        if (Flags.Flag.DELETED.equals(flag)) {
            return "\\DELETED";
        }
        if (Flags.Flag.DRAFT.equals(flag)) {
            return "\\DRAFT";
        }
        if (Flags.Flag.FLAGGED.equals(flag)) {
            return "\\FLAGGED";
        }
        if (Flags.Flag.RECENT.equals(flag)) {
            return "\\RECENT";
        }
        if (Flags.Flag.SEEN.equals(flag)) {
            return "\\FLAG";
        }
        return flag.toString();
    }

    private Query createTextQuery(SearchQuery.TextCriterion crit) throws UnsupportedSearchException {
        String value = crit.getOperator().getValue().toUpperCase(Locale.ENGLISH);
        switch (crit.getType()) {
            case BODY: {
                return this.createTermQuery(BODY_FIELD, value);
            }
            case FULL: {
                BooleanQuery query = new BooleanQuery();
                query.add(this.createTermQuery(BODY_FIELD, value), BooleanClause.Occur.SHOULD);
                query.add(this.createTermQuery(HEADERS_FIELD, value), BooleanClause.Occur.SHOULD);
                return query;
            }
        }
        throw new UnsupportedSearchException();
    }

    private Query createAllQuery(SearchQuery.AllCriterion crit) throws UnsupportedSearchException {
        BooleanQuery query = new BooleanQuery();
        query.add(this.createQuery(MessageRange.all()), BooleanClause.Occur.MUST);
        query.add((Query)new PrefixQuery(new Term(FLAGS_FIELD, "")), BooleanClause.Occur.MUST_NOT);
        return query;
    }

    private Query createConjunctionQuery(SearchQuery.ConjunctionCriterion crit, org.apache.james.mailbox.store.mail.model.Mailbox<?> mailbox, Collection<Long> recentUids) throws UnsupportedSearchException, MailboxException {
        List crits = crit.getCriteria();
        BooleanQuery conQuery = new BooleanQuery();
        switch (crit.getType()) {
            case AND: {
                for (int i = 0; i < crits.size(); ++i) {
                    conQuery.add(this.createQuery((SearchQuery.Criterion)crits.get(i), mailbox, recentUids), BooleanClause.Occur.MUST);
                }
                return conQuery;
            }
            case OR: {
                for (int i = 0; i < crits.size(); ++i) {
                    conQuery.add(this.createQuery((SearchQuery.Criterion)crits.get(i), mailbox, recentUids), BooleanClause.Occur.SHOULD);
                }
                return conQuery;
            }
            case NOR: {
                BooleanQuery nor = new BooleanQuery();
                for (int i = 0; i < crits.size(); ++i) {
                    conQuery.add(this.createQuery((SearchQuery.Criterion)crits.get(i), mailbox, recentUids), BooleanClause.Occur.SHOULD);
                }
                nor.add((Query)new TermQuery(new Term(MAILBOX_ID_FIELD, mailbox.getMailboxId().toString())), BooleanClause.Occur.MUST);
                nor.add((Query)conQuery, BooleanClause.Occur.MUST_NOT);
                return nor;
            }
        }
        throw new UnsupportedSearchException();
    }

    private Query createQuery(SearchQuery.Criterion criterion, org.apache.james.mailbox.store.mail.model.Mailbox<?> mailbox, Collection<Long> recentUids) throws UnsupportedSearchException, MailboxException {
        if (criterion instanceof SearchQuery.InternalDateCriterion) {
            SearchQuery.InternalDateCriterion crit = (SearchQuery.InternalDateCriterion)criterion;
            return this.createInternalDateQuery(crit);
        }
        if (criterion instanceof SearchQuery.SizeCriterion) {
            SearchQuery.SizeCriterion crit = (SearchQuery.SizeCriterion)criterion;
            return this.createSizeQuery(crit);
        }
        if (criterion instanceof SearchQuery.HeaderCriterion) {
            SearchQuery.HeaderCriterion crit = (SearchQuery.HeaderCriterion)criterion;
            return this.createHeaderQuery(crit);
        }
        if (criterion instanceof SearchQuery.UidCriterion) {
            SearchQuery.UidCriterion crit = (SearchQuery.UidCriterion)criterion;
            return this.createUidQuery(crit);
        }
        if (criterion instanceof SearchQuery.FlagCriterion) {
            SearchQuery.FlagCriterion crit = (SearchQuery.FlagCriterion)criterion;
            return this.createFlagQuery(this.toString(crit.getFlag()), crit.getOperator().isSet(), mailbox, recentUids);
        }
        if (criterion instanceof SearchQuery.CustomFlagCriterion) {
            SearchQuery.CustomFlagCriterion crit = (SearchQuery.CustomFlagCriterion)criterion;
            return this.createFlagQuery(crit.getFlag(), crit.getOperator().isSet(), mailbox, recentUids);
        }
        if (criterion instanceof SearchQuery.TextCriterion) {
            SearchQuery.TextCriterion crit = (SearchQuery.TextCriterion)criterion;
            return this.createTextQuery(crit);
        }
        if (criterion instanceof SearchQuery.AllCriterion) {
            return this.createAllQuery((SearchQuery.AllCriterion)criterion);
        }
        if (criterion instanceof SearchQuery.ConjunctionCriterion) {
            SearchQuery.ConjunctionCriterion crit = (SearchQuery.ConjunctionCriterion)criterion;
            return this.createConjunctionQuery(crit, mailbox, recentUids);
        }
        if (criterion instanceof SearchQuery.ModSeqCriterion) {
            return this.createModSeqQuery((SearchQuery.ModSeqCriterion)criterion);
        }
        throw new UnsupportedSearchException();
    }

    public void add(MailboxSession session, org.apache.james.mailbox.store.mail.model.Mailbox<Id> mailbox, Message<Id> membership) throws MailboxException {
        Document doc = this.createMessageDocument(session, membership);
        Document flagsDoc = this.createFlagsDocument(membership);
        try {
            this.writer.addDocument(doc);
            this.writer.addDocument(flagsDoc);
        }
        catch (CorruptIndexException e) {
            throw new MailboxException("Unable to add message to index", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to add message to index", (Exception)e);
        }
    }

    public void update(MailboxSession session, org.apache.james.mailbox.store.mail.model.Mailbox<Id> mailbox, MessageRange range, Flags f) throws MailboxException {
        try {
            IndexSearcher searcher = new IndexSearcher(IndexReader.open((IndexWriter)this.writer, (boolean)true));
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term(MAILBOX_ID_FIELD, mailbox.getMailboxId().toString())), BooleanClause.Occur.MUST);
            query.add(this.createQuery(range), BooleanClause.Occur.MUST);
            query.add((Query)new PrefixQuery(new Term(FLAGS_FIELD, "")), BooleanClause.Occur.MUST);
            TopDocs docs = searcher.search((Query)query, 100000);
            ScoreDoc[] sDocs = docs.scoreDocs;
            for (int i = 0; i < sDocs.length; ++i) {
                Document doc = searcher.doc(sDocs[i].doc);
                if (doc.getField(FLAGS_FIELD) != null) continue;
                doc.removeFields(FLAGS_FIELD);
                this.indexFlags(doc, f);
                this.writer.updateDocument(new Term(ID_FIELD, doc.get(ID_FIELD)), doc);
            }
        }
        catch (IOException e) {
            throw new MailboxException("Unable to add messages in index", (Exception)e);
        }
    }

    private Document createFlagsDocument(Message<?> message) {
        Document doc = new Document();
        doc.add((Fieldable)new org.apache.lucene.document.Field(ID_FIELD, "flags-" + message.getMailboxId().toString() + "-" + Long.toString(message.getUid()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new org.apache.lucene.document.Field(MAILBOX_ID_FIELD, message.getMailboxId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField(UID_FIELD, Field.Store.YES, true).setLongValue(message.getUid()));
        this.indexFlags(doc, message.createFlags());
        return doc;
    }

    private void indexFlags(Document doc, Flags f) {
        ArrayList<String> fString = new ArrayList<String>();
        Flags.Flag[] flags = f.getSystemFlags();
        for (int a = 0; a < flags.length; ++a) {
            fString.add(this.toString(flags[a]));
            doc.add((Fieldable)new org.apache.lucene.document.Field(FLAGS_FIELD, this.toString(flags[a]), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        String[] userFlags = f.getUserFlags();
        for (int a = 0; a < userFlags.length; ++a) {
            doc.add((Fieldable)new org.apache.lucene.document.Field(FLAGS_FIELD, userFlags[a], Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        if (flags.length == 0 && userFlags.length == 0) {
            doc.add((Fieldable)new org.apache.lucene.document.Field(FLAGS_FIELD, "", Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }

    private Query createQuery(MessageRange range) {
        switch (range.getType()) {
            case ONE: {
                return NumericRangeQuery.newLongRange((String)UID_FIELD, (Long)range.getUidFrom(), (Long)range.getUidTo(), (boolean)true, (boolean)true);
            }
            case FROM: {
                return NumericRangeQuery.newLongRange((String)UID_FIELD, (Long)range.getUidFrom(), (Long)Long.MAX_VALUE, (boolean)true, (boolean)true);
            }
        }
        return NumericRangeQuery.newLongRange((String)UID_FIELD, (Long)0L, (Long)Long.MAX_VALUE, (boolean)true, (boolean)true);
    }

    public void delete(MailboxSession session, org.apache.james.mailbox.store.mail.model.Mailbox<Id> mailbox, MessageRange range) throws MailboxException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(MAILBOX_ID_FIELD, mailbox.getMailboxId().toString())), BooleanClause.Occur.MUST);
        query.add(this.createQuery(range), BooleanClause.Occur.MUST);
        try {
            this.writer.deleteDocuments((Query)query);
        }
        catch (CorruptIndexException e) {
            throw new MailboxException("Unable to delete message from index", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to delete message from index", (Exception)e);
        }
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        MAX_DATE = cal.getTime();
        cal.set(0, 0, 1);
        MIN_DATE = cal.getTime();
        UID_SORT = new SortField(UID_FIELD, 6);
        UID_SORT_REVERSE = new SortField(UID_FIELD, 6, true);
        SIZE_SORT = new SortField(SIZE_FIELD, 6);
        SIZE_SORT_REVERSE = new SortField(SIZE_FIELD, 6, true);
        FIRST_CC_MAILBOX_SORT = new SortField(FIRST_CC_MAILBOX_NAME_FIELD, 3);
        FIRST_CC_MAILBOX_SORT_REVERSE = new SortField(FIRST_CC_MAILBOX_NAME_FIELD, 3, true);
        FIRST_TO_MAILBOX_SORT = new SortField(FIRST_TO_MAILBOX_NAME_FIELD, 3);
        FIRST_TO_MAILBOX_SORT_REVERSE = new SortField(FIRST_TO_MAILBOX_NAME_FIELD, 3, true);
        FIRST_FROM_MAILBOX_SORT = new SortField(FIRST_FROM_MAILBOX_NAME_FIELD, 3);
        FIRST_FROM_MAILBOX_SORT_REVERSE = new SortField(FIRST_FROM_MAILBOX_NAME_FIELD, 3, true);
        ARRIVAL_MAILBOX_SORT = new SortField(INTERNAL_DATE_FIELD_MILLISECOND_RESOLUTION, 6);
        ARRIVAL_MAILBOX_SORT_REVERSE = new SortField(INTERNAL_DATE_FIELD_MILLISECOND_RESOLUTION, 6, true);
        BASE_SUBJECT_SORT = new SortField(BASE_SUBJECT_FIELD, 3);
        BASE_SUBJECT_SORT_REVERSE = new SortField(BASE_SUBJECT_FIELD, 3, true);
        SENT_DATE_SORT = new SortField(SENT_DATE_SORT_FIELD_MILLISECOND_RESOLUTION, 6);
        SENT_DATE_SORT_REVERSE = new SortField(SENT_DATE_SORT_FIELD_MILLISECOND_RESOLUTION, 6, true);
        FIRST_TO_MAILBOX_DISPLAY_SORT = new SortField(FIRST_TO_MAILBOX_DISPLAY_FIELD, 3);
        FIRST_TO_MAILBOX_DISPLAY_SORT_REVERSE = new SortField(FIRST_TO_MAILBOX_DISPLAY_FIELD, 3, true);
        FIRST_FROM_MAILBOX_DISPLAY_SORT = new SortField(FIRST_FROM_MAILBOX_DISPLAY_FIELD, 3);
        FIRST_FROM_MAILBOX_DISPLAY_SORT_REVERSE = new SortField(FIRST_FROM_MAILBOX_DISPLAY_FIELD, 3, true);
    }
}

