/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.mail.Flags;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.apache.james.mailbox.store.MessageBuilder;
import org.apache.james.mailbox.store.SimpleMailboxMembership;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneMessageSearchIndexTest {
    private LuceneMessageSearchIndex<Long> index;
    private SimpleMailbox mailbox = new SimpleMailbox(0L);
    private SimpleMailbox mailbox2 = new SimpleMailbox(1L);
    private SimpleMailbox mailbox3 = new SimpleMailbox(2L);
    private static final String FROM_ADDRESS = "Harry <harry@example.org>";
    private static final String SUBJECT_PART = "Mixed";
    private static final String CUSTARD = "CUSTARD";
    private static final String RHUBARD = "Rhubard";
    private static final String BODY = "This is a simple email\r\n It has Rhubard.\r\nIt has CUSTARD.\r\nIt needs naught else.\r\n";
    Message<Long> row;

    protected boolean useLenient() {
        return true;
    }

    @Before
    public void setUp() throws Exception {
        this.index = new LuceneMessageSearchIndex(null, (Directory)new RAMDirectory(), true, this.useLenient());
        this.index.setEnableSuffixMatch(true);
        HashMap<String, String> headersSubject = new HashMap<String, String>();
        headersSubject.put("Subject", "test (fwd)");
        headersSubject.put("From", "test99 <test99@localhost>");
        headersSubject.put("To", "test2 <test2@localhost>, test3 <test3@localhost>");
        HashMap<String, String> headersTest = new HashMap<String, String>();
        headersTest.put("Test", "test");
        headersTest.put("From", "test1 <test1@localhost>");
        headersTest.put("To", "test3 <test3@localhost>, test4 <test4@localhost>");
        headersTest.put("Cc", "test21 <test21@localhost>, test6 <test6@foobar>");
        HashMap<String, String> headersTestSubject = new HashMap<String, String>();
        headersTestSubject.put("Test", "test");
        headersTestSubject.put("Subject", "test2");
        headersTestSubject.put("Date", "Thu, 14 Feb 1990 12:00:00 +0000 (GMT)");
        headersTestSubject.put("From", "test12 <test12@localhost>");
        headersTestSubject.put("Cc", "test211 <test21@localhost>, test6 <test6@foobar>");
        SimpleMailboxMembership m2 = new SimpleMailboxMembership(this.mailbox2.getMailboxId().longValue(), 1L, 0L, new Date(), 20, new Flags(Flags.Flag.ANSWERED), "My Body".getBytes(), headersSubject);
        this.index.add(null, (Mailbox)this.mailbox2, (Message)m2);
        SimpleMailboxMembership m = new SimpleMailboxMembership(this.mailbox.getMailboxId().longValue(), 1L, 0L, new Date(), 200, new Flags(Flags.Flag.ANSWERED), "My Body".getBytes(), headersSubject);
        this.index.add(null, (Mailbox)this.mailbox, (Message)m);
        Calendar cal = Calendar.getInstance();
        cal.set(1980, 2, 10);
        SimpleMailboxMembership m3 = new SimpleMailboxMembership(this.mailbox.getMailboxId().longValue(), 2L, 0L, cal.getTime(), 20, new Flags(Flags.Flag.DELETED), "My Otherbody".getBytes(), headersTest);
        this.index.add(null, (Mailbox)this.mailbox, (Message)m3);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(8000, 2, 10);
        SimpleMailboxMembership m4 = new SimpleMailboxMembership(this.mailbox.getMailboxId().longValue(), 3L, 0L, cal2.getTime(), 20, new Flags(Flags.Flag.DELETED), "My Otherbody2".getBytes(), headersTestSubject);
        this.index.add(null, (Mailbox)this.mailbox, (Message)m4);
        MessageBuilder builder = new MessageBuilder();
        builder.header("From", "test <user-from@domain.org>");
        builder.header("To", FROM_ADDRESS);
        builder.header("Subject", "A Mixed Multipart Mail");
        builder.header("Date", "Thu, 14 Feb 2008 12:00:00 +0000 (GMT)");
        builder.body = Charset.forName("us-ascii").encode(BODY).array();
        builder.uid = 10L;
        builder.mailboxId = this.mailbox3.getMailboxId();
        this.index.add(null, (Mailbox)this.mailbox3, builder.build());
    }

    @Test
    public void testBodyShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)CUSTARD));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)"CUSTARDCUSTARD"));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testBodyMatchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)RHUBARD));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testBodyShouldNotMatchPhraseOnlyInHeader() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)FROM_ADDRESS));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertFalse((boolean)result.hasNext());
        query = new SearchQuery();
        query.andCriteria(SearchQuery.bodyContains((String)SUBJECT_PART));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testTextShouldMatchPhraseInBody() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)CUSTARD));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)"CUSTARDCUSTARD"));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testTextMatchShouldBeCaseInsensitive() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)RHUBARD));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query.andCriteria(SearchQuery.mailContains((String)RHUBARD.toLowerCase(Locale.US)));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testSearchAddress() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)FROM_ADDRESS));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry"));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)"Harry@example.org"));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testSearchAddressFrom() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)"ser-from@domain.or"));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testBodyShouldMatchPhraseOnlyInHeader() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.mailContains((String)FROM_ADDRESS));
        Iterator result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
        query.andCriteria(SearchQuery.mailContains((String)SUBJECT_PART));
        result = this.index.search(null, (Mailbox)this.mailbox3, query);
        Assert.assertEquals((long)10L, (long)((Long)result.next()));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testSearchAll() throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(SearchQuery.all());
        Iterator it2 = this.index.search(null, (Mailbox)this.mailbox2, query);
        Assert.assertTrue((boolean)it2.hasNext());
        Assert.assertEquals((long)1L, (long)((Long)it2.next()));
        Assert.assertFalse((boolean)it2.hasNext());
    }

    @Test
    public void testSearchFlag() throws Exception {
        SearchQuery q = new SearchQuery();
        q.andCriteria(SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED));
        Iterator it3 = this.index.search(null, (Mailbox)this.mailbox, q);
        Assert.assertEquals((long)2L, (long)((Long)it3.next()));
        Assert.assertEquals((long)3L, (long)((Long)it3.next()));
        Assert.assertFalse((boolean)it3.hasNext());
    }

    @Test
    public void testSearchBody() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.bodyContains((String)"body"));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchMail() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.mailContains((String)"body"));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchHeaderContains() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.headerContains((String)"Subject", (String)"test"));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchHeaderExists() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.headerExists((String)"Subject"));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchFlagUnset() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchInternalDateBefore() throws Exception {
        SearchQuery q2 = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        q2.andCriteria(SearchQuery.internalDateBefore((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchInternalDateAfter() throws Exception {
        SearchQuery q2 = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        q2.andCriteria(SearchQuery.internalDateAfter((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchInternalDateOn() throws Exception {
        SearchQuery q2 = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        q2.andCriteria(SearchQuery.internalDateOn((Date)cal.getTime(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchUidMatch() throws Exception {
        SearchQuery q2 = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        q2.andCriteria(SearchQuery.uid((SearchQuery.NumericRange[])new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(1L)}));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchUidRange() throws Exception {
        SearchQuery q2 = new SearchQuery();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        q2.andCriteria(SearchQuery.uid((SearchQuery.NumericRange[])new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(1L), new SearchQuery.NumericRange(2L, 3L)}));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchSizeEquals() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.sizeEquals((long)200L));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchSizeLessThan() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.sizeLessThan((long)200L));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSearchSizeGreaterThan() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.sizeGreaterThan((long)6L));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortUid() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortUidReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.Uid, true)));
        q2.andCriteria(SearchQuery.all());
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortSentDate() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortSentDateReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.SentDate, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortBaseSubject() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortBaseSubjectReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.BaseSubject, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxFrom() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxFromReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxFrom, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxCc() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxCcReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxCc, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxTo() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortMailboxToReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.MailboxTo, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortDisplayTo() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayTo, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortDisplayToReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayTo, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortDisplayFrom() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayFrom, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortDisplayFromReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.DisplayFrom, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortArrival() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortArrivalReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.Arrival, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortSize() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, false)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testSortSizeReverse() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.all());
        q2.setSorts(Arrays.asList(new SearchQuery.Sort(SearchQuery.Sort.SortClause.Size, true)));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)1L, (long)((Long)it4.next()));
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    @Test
    public void testNot() throws Exception {
        SearchQuery q2 = new SearchQuery();
        q2.andCriteria(SearchQuery.not((SearchQuery.Criterion)SearchQuery.uid((SearchQuery.NumericRange[])new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(1L)})));
        Iterator it4 = this.index.search(null, (Mailbox)this.mailbox, q2);
        Assert.assertEquals((long)2L, (long)((Long)it4.next()));
        Assert.assertEquals((long)3L, (long)((Long)it4.next()));
        Assert.assertFalse((boolean)it4.hasNext());
    }

    private final class SimpleMailbox
    implements Mailbox<Long> {
        private long id;

        public SimpleMailbox(long id) {
            this.id = id;
        }

        public Long getMailboxId() {
            return this.id;
        }

        public String getNamespace() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void setNamespace(String namespace) {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getUser() {
            throw new UnsupportedOperationException("Not supported");
        }

        public void setUser(String user) {
            throw new UnsupportedOperationException("Not supported");
        }

        public String getName() {
            return Long.toString(this.id);
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Not supported");
        }

        public long getUidValidity() {
            return 0L;
        }

        public MailboxACL getACL() {
            return SimpleMailboxACL.OWNER_FULL_ACL;
        }

        public void setACL(MailboxACL acl) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

