/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase.mail;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.mail.HBaseMailboxMapper;
import org.apache.james.mailbox.hbase.mail.HBaseModSeqProvider;
import org.apache.james.mailbox.hbase.mail.HBaseUidProvider;
import org.apache.james.mailbox.hbase.mail.model.HBaseMailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUidAndModSeqProviderTest {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseUidAndModSeqProviderTest.class);
    private static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();
    private static Configuration conf;
    private static HBaseUidProvider uidProvider;
    private static HBaseModSeqProvider modSeqProvider;
    private static HBaseMailboxMapper mapper;
    private static List<HBaseMailbox> mailboxList;
    private static List<MailboxPath> pathsList;
    private static final int NAMESPACES = 5;
    private static final int USERS = 5;
    private static final int MAILBOX_NO = 5;
    private static final char SEPARATOR = '%';

    @Before
    public void setUpClass() throws Exception {
        this.ensureTables();
        this.clearTables();
        conf = CLUSTER.getConf();
        uidProvider = new HBaseUidProvider(conf);
        modSeqProvider = new HBaseModSeqProvider(conf);
        mapper = new HBaseMailboxMapper(conf);
        HBaseUidAndModSeqProviderTest.fillMailboxList();
        for (HBaseMailbox mailbox : mailboxList) {
            mapper.save((Mailbox)mailbox);
        }
    }

    private void ensureTables() throws IOException {
        CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
        CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
        CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
    }

    private void clearTables() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    private static void fillMailboxList() {
        mailboxList = new ArrayList<HBaseMailbox>();
        pathsList = new ArrayList<MailboxPath>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 5; ++k) {
                    String name = j == 3 ? "test%subbox" + k : "mailbox" + k;
                    MailboxPath path = new MailboxPath("namespace" + i, "user" + j, name);
                    pathsList.add(path);
                    mailboxList.add(new HBaseMailbox(path, 13L));
                }
            }
        }
        LOG.info("Created test case with {} mailboxes and {} paths", (Object)mailboxList.size(), (Object)pathsList.size());
    }

    @Test
    public void testLastUid() throws Exception {
        LOG.info("lastUid");
        MailboxPath path = new MailboxPath("gsoc", "ieugen", "Trash");
        HBaseMailbox newBox = new HBaseMailbox(path, 1234L);
        mapper.save((Mailbox)newBox);
        mailboxList.add(newBox);
        pathsList.add(path);
        MailboxSession session = null;
        Optional result = uidProvider.lastUid(session, (Mailbox)newBox);
        Assert.assertEquals((Object)Optional.absent(), (Object)result);
        for (int i = 1; i < 10; ++i) {
            MessageUid uid = uidProvider.nextUid(session, (Mailbox)newBox);
            Assert.assertEquals((Object)uid, (Object)uidProvider.lastUid(session, (Mailbox)newBox).get());
        }
    }

    @Test
    public void testNextUid() throws Exception {
        LOG.info("nextUid");
        HBaseMailbox mailbox = mailboxList.get(mailboxList.size() / 2);
        MailboxSession session = null;
        Optional lastUid = uidProvider.lastUid(session, (Mailbox)mailbox);
        for (int i = 0; i < 10; ++i) {
            lastUid = lastUid.isPresent() ? Optional.of((Object)((MessageUid)lastUid.get()).next()) : Optional.of((Object)MessageUid.MIN_VALUE);
            MessageUid result = uidProvider.nextUid(session, (Mailbox)mailbox);
            Assert.assertEquals((Object)lastUid.get(), (Object)result);
        }
    }

    @Test
    public void testHighestModSeq() throws Exception {
        LOG.info("highestModSeq");
        LOG.info("lastUid");
        MailboxPath path = new MailboxPath("gsoc", "ieugen", "Trash");
        HBaseMailbox newBox = new HBaseMailbox(path, 1234L);
        mapper.save((Mailbox)newBox);
        mailboxList.add(newBox);
        pathsList.add(path);
        MailboxSession session = null;
        long result = modSeqProvider.highestModSeq(session, (Mailbox)newBox);
        Assert.assertEquals((long)0L, (long)result);
        for (int i = 1; i < 10; ++i) {
            long uid = modSeqProvider.nextModSeq(session, (Mailbox)newBox);
            Assert.assertEquals((long)uid, (long)modSeqProvider.highestModSeq(session, (Mailbox)newBox));
        }
    }

    @Test
    public void testNextModSeq() throws Exception {
        LOG.info("nextModSeq");
        HBaseMailbox mailbox = mailboxList.get(mailboxList.size() / 2);
        MailboxSession session = null;
        long lastUid = modSeqProvider.highestModSeq(session, (Mailbox)mailbox);
        int i = (int)lastUid + 1;
        while ((long)i < lastUid + 10L) {
            long result = modSeqProvider.nextModSeq(session, (Mailbox)mailbox);
            Assert.assertEquals((long)i, (long)result);
            ++i;
        }
    }
}

