/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.mail.HBaseMailboxMapperTest;
import org.apache.james.mailbox.hbase.mail.HBaseMessageMapper;
import org.apache.james.mailbox.hbase.mail.HBaseModSeqProvider;
import org.apache.james.mailbox.hbase.mail.HBaseUidProvider;
import org.apache.james.mailbox.hbase.mail.model.HBaseMailbox;
import org.apache.james.mailbox.mock.MockMailboxSession;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMailboxMessageMapperTest {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMailboxMapperTest.class);
    public static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();
    private static HBaseUidProvider uidProvider;
    private static HBaseModSeqProvider modSeqProvider;
    private static HBaseMessageMapper messageMapper;
    private static final List<MailboxPath> MBOX_PATHS;
    private static final List<Mailbox> MBOXES;
    private static final List<MailboxMessage> MESSAGE_NO;
    private static final int COUNT = 5;
    private static Configuration conf;
    private DefaultMessageId.Factory messageIdFactory;
    private static final byte[] messageTemplate;
    private static final SharedInputStream content;

    @Before
    public void setUp() throws Exception {
        this.ensureTables();
        this.clearTables();
        conf = CLUSTER.getConf();
        uidProvider = new HBaseUidProvider(conf);
        modSeqProvider = new HBaseModSeqProvider(conf);
        this.messageIdFactory = new DefaultMessageId.Factory();
        this.generateTestData();
        MockMailboxSession session = new MockMailboxSession("ieugen");
        messageMapper = new HBaseMessageMapper((MailboxSession)session, (UidProvider)uidProvider, (ModSeqProvider)modSeqProvider, (MessageId.Factory)this.messageIdFactory, conf);
        for (MailboxMessage message : MESSAGE_NO) {
            messageMapper.add(MBOXES.get(1), message);
        }
    }

    private void ensureTables() throws IOException {
        CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
        CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
        CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
    }

    private void clearTables() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    public void generateTestData() {
        Random random = new Random();
        PropertyBuilder propBuilder = new PropertyBuilder();
        for (int i = 0; i < 5; ++i) {
            MailboxPath mboxPath = i % 2 == 0 ? new MailboxPath("gsoc", "ieugen" + i, "INBOX") : new MailboxPath("gsoc", "ieugen" + i, "INBOX.box" + i);
            MBOX_PATHS.add(mboxPath);
            MBOXES.add((Mailbox)new HBaseMailbox(MBOX_PATHS.get(i), random.nextLong()));
            propBuilder.setProperty("gsoc", "prop" + i, "value");
        }
        propBuilder.setMediaType("text");
        propBuilder.setSubType("html");
        propBuilder.setTextualLineCount(Long.valueOf(2L));
        Flags flags = new Flags(Flags.Flag.RECENT);
        Date today = new Date();
        for (int i = 0; i < 10; ++i) {
            SimpleMailboxMessage myMsg = new SimpleMailboxMessage(this.messageIdFactory.generate(), today, (long)messageTemplate.length, messageTemplate.length - 20, content, flags, propBuilder, MBOXES.get(1).getMailboxId());
            if (i == 9) {
                flags.add(Flags.Flag.SEEN);
                flags.remove(Flags.Flag.RECENT);
                myMsg.setFlags(flags);
            }
            MESSAGE_NO.add((MailboxMessage)myMsg);
        }
    }

    @Test
    public void testMessageMapperScenario() throws Exception {
        this.testCountMessagesInMailbox();
        this.testCountUnseenMessagesInMailbox();
        this.testFindFirstUnseenMessageUid();
        this.testFindRecentMessageUidsInMailbox();
        this.testAdd();
        this.testGetLastUid();
        this.testGetHighestModSeq();
    }

    private void testCountMessagesInMailbox() throws Exception {
        LOG.info("countMessagesInMailbox");
        long messageCount = messageMapper.countMessagesInMailbox(MBOXES.get(1));
        Assert.assertEquals((long)MESSAGE_NO.size(), (long)messageCount);
    }

    private void testCountUnseenMessagesInMailbox() throws Exception {
        LOG.info("countUnseenMessagesInMailbox");
        long unseen = messageMapper.countUnseenMessagesInMailbox(MBOXES.get(1));
        Assert.assertEquals((long)(MESSAGE_NO.size() - 1), (long)unseen);
    }

    private void testFindFirstUnseenMessageUid() throws Exception {
        LOG.info("findFirstUnseenMessageUid");
        MessageUid uid = messageMapper.findFirstUnseenMessageUid(MBOXES.get(1));
        Assert.assertEquals((Object)MessageUid.of((long)1L), (Object)uid);
    }

    private void testFindRecentMessageUidsInMailbox() throws Exception {
        LOG.info("findRecentMessageUidsInMailbox");
        List recentMessages = messageMapper.findRecentMessageUidsInMailbox(MBOXES.get(1));
        Assert.assertEquals((long)(MESSAGE_NO.size() - 1), (long)recentMessages.size());
    }

    private void testAdd() throws Exception {
        LOG.info("add");
        long msgCount = messageMapper.countMessagesInMailbox(MBOXES.get(1));
        LOG.info(msgCount + " " + MESSAGE_NO.size());
        Assert.assertEquals((long)MESSAGE_NO.size(), (long)msgCount);
    }

    private void testGetLastUid() throws Exception {
        LOG.info("getLastUid");
        MessageUid lastUid = (MessageUid)messageMapper.getLastUid(MBOXES.get(1)).get();
        Assert.assertEquals((Object)MessageUid.of((long)MESSAGE_NO.size()), (Object)lastUid);
    }

    private void testGetHighestModSeq() throws Exception {
        LOG.info("getHighestModSeq");
        long highestModSeq = messageMapper.getHighestModSeq(MBOXES.get(1));
        Assert.assertEquals((long)MESSAGE_NO.size(), (long)highestModSeq);
    }

    static {
        MBOX_PATHS = new ArrayList<MailboxPath>();
        MBOXES = new ArrayList<Mailbox>();
        MESSAGE_NO = new ArrayList<MailboxMessage>();
        messageTemplate = Bytes.toBytes((String)"Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 02\nTo: mooch@owatagu.siam.edu\nMailboxMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nTest\n\n.");
        content = new SharedByteArrayInputStream(messageTemplate);
    }
}

