/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseId;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.HBaseUtils;
import org.apache.james.mailbox.hbase.io.ChunkInputStream;
import org.apache.james.mailbox.hbase.io.ChunkOutputStream;
import org.apache.james.mailbox.hbase.mail.HBaseMailboxMapper;
import org.apache.james.mailbox.hbase.mail.model.HBaseMailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMailboxMapperTest {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMailboxMapperTest.class);
    public static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();
    private static Configuration conf;
    private static HBaseMailboxMapper mapper;
    private static List<HBaseMailbox> mailboxList;
    private static List<MailboxPath> pathsList;
    private static List<HBaseId> idsList;
    private static final int NAMESPACES = 5;
    private static final int USERS = 5;
    private static final int MAILBOX_NO = 5;
    private static final char SEPARATOR = '%';

    @Before
    public void setUp() throws Exception {
        this.ensureTables();
        this.clearTables();
        conf = CLUSTER.getConf();
        HBaseMailboxMapperTest.fillMailboxList();
        mapper = new HBaseMailboxMapper(conf);
        for (HBaseMailbox mailbox : mailboxList) {
            mapper.save((Mailbox)mailbox);
        }
    }

    private void ensureTables() throws IOException {
        CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
        CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
        CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
    }

    private void clearTables() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    @Test
    public void testMailboxMapperScenario() throws Exception {
        this.testFindMailboxByPath();
        this.testFindMailboxById();
        this.testFindMailboxWithPathLike();
        this.testList();
        this.testSave();
        this.testDelete();
        this.testHasChildren();
        this.testDeleteAllMailboxes();
        this.testChunkStream();
    }

    private void testFindMailboxByPath() throws Exception {
        LOG.info("findMailboxByPath");
        for (MailboxPath path : pathsList) {
            LOG.info("Searching for " + path);
            HBaseMailbox mailbox = (HBaseMailbox)mapper.findMailboxByPath(path);
            Assert.assertEquals((Object)path, (Object)new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), mailbox.getName()));
        }
    }

    private void testFindMailboxById() throws Exception {
        LOG.info("findMailboxById");
        for (MailboxId mailboxId : idsList) {
            LOG.info("Searching for " + mailboxId.serialize());
            HBaseMailbox mailbox = (HBaseMailbox)mapper.findMailboxById(mailboxId);
            Assert.assertEquals((Object)mailbox.getMailboxId(), (Object)mailboxId);
        }
    }

    private void testFindMailboxWithPathLike() throws Exception {
        LOG.info("findMailboxWithPathLike");
        MailboxPath path = pathsList.get(pathsList.size() / 2);
        List result = mapper.findMailboxWithPathLike(path);
        Assert.assertEquals((long)1L, (long)result.size());
        int start = 3;
        int end = 7;
        for (int i = start; i < end; ++i) {
            MailboxPath newPath = new MailboxPath(path);
            newPath.setName(i + newPath.getName() + " " + i);
            if (i % 2 == 0) {
                newPath.setUser(null);
            }
            this.addMailbox(new HBaseMailbox(newPath, 1234L));
        }
        result = mapper.findMailboxWithPathLike(path);
        Assert.assertEquals((long)(end - start + 1), (long)result.size());
    }

    private void testList() throws Exception {
        LOG.info("list");
        List result = mapper.list();
        Assert.assertEquals((long)mailboxList.size(), (long)result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSave() throws Exception {
        LOG.info("save and mailboxFromResult");
        HTable mailboxes = new HTable(conf, HBaseNames.MAILBOXES_TABLE);
        try {
            HBaseMailbox mlbx = mailboxList.get(mailboxList.size() / 2);
            Get get = new Get(mlbx.getMailboxId().toBytes());
            get.addFamily(HBaseNames.MAILBOX_CF);
            Result result = mailboxes.get(get);
            HBaseMailbox newValue = (HBaseMailbox)HBaseUtils.mailboxFromResult((Result)result);
            Assert.assertEquals((Object)mlbx, (Object)newValue);
            Assert.assertEquals((Object)mlbx.getUser(), (Object)newValue.getUser());
            Assert.assertEquals((Object)mlbx.getName(), (Object)newValue.getName());
            Assert.assertEquals((Object)mlbx.getNamespace(), (Object)newValue.getNamespace());
            Assert.assertEquals((Object)mlbx.getMailboxId(), (Object)newValue.getMailboxId());
            Assert.assertEquals((long)mlbx.getLastUid(), (long)newValue.getLastUid());
            Assert.assertEquals((long)mlbx.getUidValidity(), (long)newValue.getUidValidity());
            Assert.assertEquals((long)mlbx.getHighestModSeq(), (long)newValue.getHighestModSeq());
            Assert.assertArrayEquals((byte[])mlbx.getMailboxId().toBytes(), (byte[])newValue.getMailboxId().toBytes());
        }
        finally {
            mailboxes.close();
        }
    }

    private void testDelete() throws Exception {
        LOG.info("delete");
        int offset = 5;
        int notFoundCount = 0;
        Iterator<HBaseMailbox> iterator = mailboxList.subList(mailboxList.size() - offset, mailboxList.size()).iterator();
        while (iterator.hasNext()) {
            HBaseMailbox mailbox = iterator.next();
            mapper.delete((Mailbox)mailbox);
            iterator.remove();
            MailboxPath path = new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), mailbox.getName());
            pathsList.remove(path);
            LOG.info("Removing mailbox: {}", (Object)path);
            try {
                mapper.findMailboxByPath(path);
            }
            catch (MailboxNotFoundException e) {
                LOG.info("Succesfully removed {}", (Object)mailbox);
                ++notFoundCount;
            }
        }
        Assert.assertEquals((long)offset, (long)notFoundCount);
        Assert.assertEquals((long)mailboxList.size(), (long)mapper.list().size());
    }

    private void testHasChildren() throws Exception {
        LOG.info("hasChildren");
        for (MailboxPath path : pathsList) {
            HBaseMailbox mailbox = new HBaseMailbox(path, 12455L);
            String oldName = mailbox.getName();
            if (path.getUser().equals("user3")) {
                mailbox.setName("test");
            }
            boolean result = mapper.hasChildren((Mailbox)mailbox, '%');
            mailbox.setName(oldName);
            if (path.getUser().equals("user3")) {
                Assert.assertTrue((boolean)result);
                continue;
            }
            Assert.assertFalse((boolean)result);
        }
    }

    private void testDeleteAllMailboxes() throws MailboxException {
        LOG.info("deleteAllMailboxes");
        mapper.deleteAllMailboxes();
        Assert.assertEquals((long)0L, (long)mapper.list().size());
        HBaseMailboxMapperTest.fillMailboxList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChunkStream() throws IOException {
        LOG.info("Checking ChunkOutpuStream and ChunkInputStream");
        String original = "This is a proper test for the HBase ChunkInputStream andChunkOutputStream. This text must be larger than the chunk size so we writeand read more then one chunk size. I think that a few more lore ipsum lineswill be enough.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum";
        byte[] data = Bytes.toBytes((String)"This is a proper test for the HBase ChunkInputStream andChunkOutputStream. This text must be larger than the chunk size so we writeand read more then one chunk size. I think that a few more lore ipsum lineswill be enough.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum");
        ChunkOutputStream out = new ChunkOutputStream(conf, HBaseNames.MESSAGES_TABLE, HBaseNames.MESSAGE_DATA_BODY_CF, Bytes.toBytes((String)"10"), 10);
        ChunkInputStream in = new ChunkInputStream(conf, HBaseNames.MESSAGES_TABLE, HBaseNames.MESSAGE_DATA_BODY_CF, Bytes.toBytes((String)"10"));
        try {
            int b;
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
            while ((b = bin.read()) != -1) {
                out.write(b);
            }
            out.close();
            while ((b = in.read()) != -1) {
                bout.write(b);
            }
            String s = bout.toString();
            Assert.assertTrue((boolean)"This is a proper test for the HBase ChunkInputStream andChunkOutputStream. This text must be larger than the chunk size so we writeand read more then one chunk size. I think that a few more lore ipsum lineswill be enough.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum".equals(s));
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void fillMailboxList() {
        mailboxList = new ArrayList<HBaseMailbox>();
        pathsList = new ArrayList<MailboxPath>();
        idsList = new ArrayList<HBaseId>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 5; ++k) {
                    String name = j == 3 ? "test%subbox" + k : "mailbox" + k;
                    MailboxPath path = new MailboxPath("namespace" + i, "user" + j, name);
                    pathsList.add(path);
                    HBaseMailbox mailbox = new HBaseMailbox(path, 13L);
                    mailboxList.add(mailbox);
                    idsList.add(mailbox.getMailboxId());
                }
            }
        }
        LOG.info("Created test case with {} mailboxes and {} paths", (Object)mailboxList.size(), (Object)pathsList.size());
    }

    private void addMailbox(HBaseMailbox mailbox) throws MailboxException {
        mailboxList.add(mailbox);
        pathsList.add(new MailboxPath(mailbox.getNamespace(), mailbox.getUser(), mailbox.getName()));
        mapper = new HBaseMailboxMapper(conf);
        mapper.save((Mailbox)mailbox);
        LOG.info("Added new mailbox: {} paths: {}", (Object)mailboxList.size(), (Object)pathsList.size());
    }
}

