/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase;

import com.google.common.base.Throwables;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxManagerStressTest;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseMailboxManager;
import org.apache.james.mailbox.hbase.HBaseMailboxSessionMapperFactory;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.mail.HBaseModSeqProvider;
import org.apache.james.mailbox.hbase.mail.HBaseUidProvider;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.junit.After;
import org.junit.Ignore;

@Ignore(value="https://issues.apache.org/jira/browse/MAILBOX-293")
public class HBaseMailboxManagerStressTest
extends MailboxManagerStressTest {
    private static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();

    protected MailboxManager provideManager() {
        this.ensureTables();
        HBaseUidProvider uidProvider = new HBaseUidProvider(CLUSTER.getConf());
        HBaseModSeqProvider modSeqProvider = new HBaseModSeqProvider(CLUSTER.getConf());
        DefaultMessageId.Factory messageIdFactory = new DefaultMessageId.Factory();
        HBaseMailboxSessionMapperFactory mapperFactory = new HBaseMailboxSessionMapperFactory(CLUSTER.getConf(), (UidProvider)uidProvider, (ModSeqProvider)modSeqProvider, (MessageId.Factory)messageIdFactory);
        Authenticator noAuthenticator = null;
        Authorizator noAuthorizator = null;
        HBaseMailboxManager manager = new HBaseMailboxManager(mapperFactory, noAuthenticator, noAuthorizator, (MailboxACLResolver)new UnionMailboxACLResolver(), (GroupMembershipResolver)new SimpleGroupMembershipResolver(), new MessageParser(), (MessageId.Factory)messageIdFactory);
        try {
            manager.init();
        }
        catch (MailboxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return manager;
    }

    @After
    public void tearDown() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    private void ensureTables() {
        try {
            CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
            CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
            CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

