/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import java.time.Duration;
import org.apache.james.mailbox.events.RetryBackoffConfiguration;
import org.apache.james.mailbox.events.WaitDelayGenerator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class WaitDelayGeneratorTest {
    WaitDelayGeneratorTest() {
    }

    @Test
    void generateDelayShouldReturnZeroWhenZeroRetryCount() {
        WaitDelayGenerator generator = WaitDelayGenerator.of((RetryBackoffConfiguration)RetryBackoffConfiguration.DEFAULT);
        Assertions.assertThat((Comparable)generator.generateDelay(0)).isEqualTo((Object)Duration.ofMillis(0L));
    }

    @Test
    void generateDelayShouldReturnByRandomInRangeOfExponentialGrowthOfRetryCount() {
        WaitDelayGenerator generator = WaitDelayGenerator.of((RetryBackoffConfiguration)RetryBackoffConfiguration.builder().maxRetries(4).firstBackoff(Duration.ofMillis(100L)).jitterFactor(0.5).build());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(generator.generateDelay(1).toMillis()).isBetween(Long.valueOf(100L), Long.valueOf(150L));
            softly.assertThat(generator.generateDelay(2).toMillis()).isBetween(Long.valueOf(200L), Long.valueOf(300L));
            softly.assertThat(generator.generateDelay(3).toMillis()).isBetween(Long.valueOf(400L), Long.valueOf(600L));
            softly.assertThat(generator.generateDelay(4).toMillis()).isBetween(Long.valueOf(800L), Long.valueOf(1200L));
        });
    }

    @Test
    void generateDelayShouldReturnZeroWhenZeroMaxRetries() {
        WaitDelayGenerator generator = WaitDelayGenerator.of((RetryBackoffConfiguration)RetryBackoffConfiguration.builder().maxRetries(0).firstBackoff(Duration.ofMillis(1000L)).jitterFactor(0.5).build());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)generator.generateDelay(1)).isEqualTo((Object)Duration.ZERO);
            softly.assertThat((Comparable)generator.generateDelay(2)).isEqualTo((Object)Duration.ZERO);
            softly.assertThat((Comparable)generator.generateDelay(3)).isEqualTo((Object)Duration.ZERO);
        });
    }

    @Test
    void generateDelayShouldReturnZeroWhenZeroFirstBackOff() {
        WaitDelayGenerator generator = WaitDelayGenerator.of((RetryBackoffConfiguration)RetryBackoffConfiguration.builder().maxRetries(3).firstBackoff(Duration.ZERO).jitterFactor(0.5).build());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)generator.generateDelay(1)).isEqualTo((Object)Duration.ZERO);
            softly.assertThat((Comparable)generator.generateDelay(2)).isEqualTo((Object)Duration.ZERO);
            softly.assertThat((Comparable)generator.generateDelay(3)).isEqualTo((Object)Duration.ZERO);
        });
    }

    @Test
    void generateDelayShouldReturnFloorOfExponentialGrowthStepsWhenZeroJitterFactor() {
        WaitDelayGenerator generator = WaitDelayGenerator.of((RetryBackoffConfiguration)RetryBackoffConfiguration.builder().maxRetries(3).firstBackoff(Duration.ofMillis(100L)).jitterFactor(0.0).build());
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)generator.generateDelay(1)).isEqualTo((Object)Duration.ofMillis(100L));
            softly.assertThat((Comparable)generator.generateDelay(2)).isEqualTo((Object)Duration.ofMillis(200L));
            softly.assertThat((Comparable)generator.generateDelay(3)).isEqualTo((Object)Duration.ofMillis(400L));
        });
    }
}

