/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import java.util.Objects;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.events.RoutingKeyConverter;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RoutingKeyConverterTest {
    private static final RegistrationKey REGISTRATION_KEY_1 = new MailboxIdRegistrationKey((MailboxId)TestId.of((long)42L));
    private static final String ROUTING_KEY_1 = "org.apache.james.mailbox.events.MailboxIdRegistrationKey:42";
    private RoutingKeyConverter testee = RoutingKeyConverter.forFactories((RegistrationKey.Factory[])new RegistrationKey.Factory[]{new TestRegistrationKey.Factory(), new MailboxIdRegistrationKey.Factory((MailboxId.Factory)new TestId.Factory())});

    RoutingKeyConverterTest() {
    }

    @Test
    void toRoutingKeyShouldTransformAKeyIntoAString() {
        Assertions.assertThat((String)RoutingKeyConverter.RoutingKey.of((RegistrationKey)REGISTRATION_KEY_1).asString()).isEqualTo((Object)ROUTING_KEY_1);
    }

    @Test
    void toRegistrationKeyShouldReturnCorrespondingRoutingKey() {
        Assertions.assertThat((Object)this.testee.toRegistrationKey(ROUTING_KEY_1)).isEqualTo((Object)REGISTRATION_KEY_1);
    }

    @Test
    void toRoutingKeyShouldAcceptSeparator() {
        Assertions.assertThat((String)RoutingKeyConverter.RoutingKey.of((RegistrationKey)new TestRegistrationKey("a:b")).asString()).isEqualTo((Object)"org.apache.james.mailbox.events.RoutingKeyConverterTest$TestRegistrationKey:a:b");
    }

    @Test
    void toRegistrationKeyShouldAcceptSeparator() {
        Assertions.assertThat((Object)this.testee.toRegistrationKey("org.apache.james.mailbox.events.RoutingKeyConverterTest$TestRegistrationKey:a:b")).isEqualTo((Object)new TestRegistrationKey("a:b"));
    }

    @Test
    void toRoutingKeyShouldAcceptEmptyValue() {
        Assertions.assertThat((String)RoutingKeyConverter.RoutingKey.of((RegistrationKey)new TestRegistrationKey("")).asString()).isEqualTo((Object)"org.apache.james.mailbox.events.RoutingKeyConverterTest$TestRegistrationKey:");
    }

    @Test
    void toRegistrationKeyShouldAcceptEmptyValue() {
        Assertions.assertThat((Object)this.testee.toRegistrationKey("org.apache.james.mailbox.events.RoutingKeyConverterTest$TestRegistrationKey:")).isEqualTo((Object)new TestRegistrationKey(""));
    }

    @Test
    void toRegistrationKeyShouldRejectNull() {
        Assertions.assertThatThrownBy(() -> this.testee.toRegistrationKey(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void toRegistrationKeyShouldRejectEmptyString() {
        Assertions.assertThatThrownBy(() -> this.testee.toRegistrationKey("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toRegistrationKeyShouldRejectNoSeparator() {
        Assertions.assertThatThrownBy(() -> this.testee.toRegistrationKey("noSeparator")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toRegistrationKeyShouldRejectUnknownRegistrationKeyClass() {
        Assertions.assertThatThrownBy(() -> this.testee.toRegistrationKey("unknown:")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void toRegistrationKeyShouldRejectInvalidValue() {
        Assertions.assertThatThrownBy(() -> this.testee.toRegistrationKey("org.apache.james.mailbox.events.MailboxIdRegistrationKey:invalid")).isInstanceOf(IllegalArgumentException.class);
    }

    static class TestRegistrationKey
    implements RegistrationKey {
        private final String value;

        TestRegistrationKey(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof TestRegistrationKey) {
                TestRegistrationKey that = (TestRegistrationKey)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        static class Factory
        implements RegistrationKey.Factory {
            Factory() {
            }

            public Class<? extends RegistrationKey> forClass() {
                return TestRegistrationKey.class;
            }

            public RegistrationKey fromString(String asString) {
                return new TestRegistrationKey(asString);
            }
        }
    }
}

