/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.events.MailboxListenerRegistry;
import org.apache.james.mailbox.events.RegistrationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class MailboxListenerRegistryTest {
    private static final MailboxIdRegistrationKey KEY_1 = new MailboxIdRegistrationKey((MailboxId)TestId.of((long)42L));
    private static final Runnable NOOP = () -> {};
    private MailboxListenerRegistry testee;

    MailboxListenerRegistryTest() {
    }

    @BeforeEach
    void setUp() {
        this.testee = new MailboxListenerRegistry();
    }

    @Test
    void getLocalMailboxListenersShouldReturnEmptyWhenNone() {
        Assertions.assertThat((List)((List)this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).isEmpty();
    }

    @Test
    void getLocalMailboxListenersShouldReturnPreviouslyAddedListener() {
        MailboxListener listener = event -> {};
        this.testee.addListener((RegistrationKey)KEY_1, listener, NOOP);
        Assertions.assertThat((List)((List)this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).containsOnly((Object[])new MailboxListener[]{listener});
    }

    @Test
    void getLocalMailboxListenersShouldReturnPreviouslyAddedListeners() {
        MailboxListener listener1 = event -> {};
        MailboxListener listener2 = event -> {};
        this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
        this.testee.addListener((RegistrationKey)KEY_1, listener2, NOOP);
        Assertions.assertThat((List)((List)this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).containsOnly((Object[])new MailboxListener[]{listener1, listener2});
    }

    @Test
    void getLocalMailboxListenersShouldNotReturnRemovedListeners() {
        MailboxListener listener1 = event -> {};
        MailboxListener listener2 = event -> {};
        this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
        this.testee.addListener((RegistrationKey)KEY_1, listener2, NOOP);
        this.testee.removeListener((RegistrationKey)KEY_1, listener2, NOOP);
        Assertions.assertThat((List)((List)this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).containsOnly((Object[])new MailboxListener[]{listener1});
    }

    @Test
    void addListenerShouldRunTaskWhenNoPreviouslyRegisteredListeners() {
        MailboxListener listener = event -> {};
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.testee.addListener((RegistrationKey)KEY_1, listener, () -> atomicBoolean.set(true));
        Assertions.assertThat((AtomicBoolean)atomicBoolean).isTrue();
    }

    @Test
    void addListenerShouldNotRunTaskWhenPreviouslyRegisteredListeners() {
        MailboxListener listener = event -> {};
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.testee.addListener((RegistrationKey)KEY_1, listener, NOOP);
        this.testee.addListener((RegistrationKey)KEY_1, listener, () -> atomicBoolean.set(true));
        Assertions.assertThat((AtomicBoolean)atomicBoolean).isFalse();
    }

    @Test
    void removeListenerShouldNotRunTaskWhenNoListener() {
        MailboxListener listener = event -> {};
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.testee.removeListener((RegistrationKey)KEY_1, listener, () -> atomicBoolean.set(true));
        Assertions.assertThat((AtomicBoolean)atomicBoolean).isFalse();
    }

    @Test
    void removeListenerShouldNotRunTaskWhenSeveralListener() {
        MailboxListener listener = event -> {};
        MailboxListener listener2 = event -> {};
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.testee.addListener((RegistrationKey)KEY_1, listener, NOOP);
        this.testee.addListener((RegistrationKey)KEY_1, listener2, NOOP);
        this.testee.removeListener((RegistrationKey)KEY_1, listener, () -> atomicBoolean.set(true));
        Assertions.assertThat((AtomicBoolean)atomicBoolean).isFalse();
    }

    @Test
    void removeListenerShouldRunTaskWhenOneListener() {
        MailboxListener listener = event -> {};
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.testee.addListener((RegistrationKey)KEY_1, listener, NOOP);
        this.testee.removeListener((RegistrationKey)KEY_1, listener, () -> atomicBoolean.set(true));
        Assertions.assertThat((AtomicBoolean)atomicBoolean).isTrue();
    }

    @Nested
    class ConcurrentTest {
        private final Duration ONE_SECOND = Duration.ofSeconds(1L);

        ConcurrentTest() {
        }

        @Test
        void getLocalMailboxListenersShouldReturnPreviousAddedListener() throws Exception {
            MailboxListener listener = event -> {};
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener, NOOP)).threadCount(10).operationCount(10).runSuccessfullyWithin(this.ONE_SECOND);
            Assertions.assertThat((List)((List)MailboxListenerRegistryTest.this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).containsOnly((Object[])new MailboxListener[]{listener});
        }

        @Test
        void getLocalMailboxListenersShouldReturnAllPreviousAddedListeners() throws Exception {
            MailboxListener listener1 = event -> {};
            MailboxListener listener2 = event -> {};
            MailboxListener listener3 = event -> {};
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> {
                if (threadNumber % 3 == 0) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
                } else if (threadNumber % 3 == 1) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener2, NOOP);
                } else if (threadNumber % 3 == 2) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener3, NOOP);
                }
            }).threadCount(6).operationCount(10).runSuccessfullyWithin(this.ONE_SECOND);
            Assertions.assertThat((List)((List)MailboxListenerRegistryTest.this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).containsOnly((Object[])new MailboxListener[]{listener1, listener2, listener3});
        }

        @Test
        void getLocalMailboxListenersShouldReturnEmptyWhenRemoveAddedListener() throws Exception {
            MailboxListener listener1 = event -> {};
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> MailboxListenerRegistryTest.this.testee.removeListener((RegistrationKey)KEY_1, listener1, NOOP)).threadCount(10).operationCount(10).runSuccessfullyWithin(this.ONE_SECOND);
            Assertions.assertThat((List)((List)MailboxListenerRegistryTest.this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).collectList().block())).isEmpty();
        }

        @Test
        void addListenerOnlyRunTaskOnceForEmptyRegistry() throws Exception {
            MailboxListener listener1 = event -> {};
            MailboxListener listener2 = event -> {};
            MailboxListener listener3 = event -> {};
            AtomicInteger runIfEmptyCount = new AtomicInteger(0);
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> {
                if (threadNumber % 3 == 0) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener1, runIfEmptyCount::incrementAndGet);
                } else if (threadNumber % 3 == 1) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener2, runIfEmptyCount::incrementAndGet);
                } else if (threadNumber % 3 == 2) {
                    MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener3, runIfEmptyCount::incrementAndGet);
                }
            }).threadCount(6).operationCount(10).runSuccessfullyWithin(this.ONE_SECOND);
            Assertions.assertThat((int)runIfEmptyCount.get()).isEqualTo(1);
        }

        @Test
        void removeListenerOnlyRunTaskOnceForEmptyRegistry() throws Exception {
            MailboxListener listener1 = event -> {};
            AtomicInteger runIfEmptyCount = new AtomicInteger(0);
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
            ConcurrentTestRunner.builder().operation((threadNumber, operationNumber) -> MailboxListenerRegistryTest.this.testee.removeListener((RegistrationKey)KEY_1, listener1, runIfEmptyCount::incrementAndGet)).threadCount(10).operationCount(10).runSuccessfullyWithin(this.ONE_SECOND);
            Assertions.assertThat((int)runIfEmptyCount.get()).isEqualTo(1);
        }

        @Test
        void iterationShouldPerformOnASnapshotOfListenersSet() throws Exception {
            MailboxListener listener1 = event -> {};
            MailboxListener listener2 = event -> {};
            MailboxListener listener3 = event -> {};
            MailboxListener listener4 = event -> {};
            MailboxListener listener5 = event -> {};
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener1, NOOP);
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener2, NOOP);
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener3, NOOP);
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener4, NOOP);
            MailboxListenerRegistryTest.this.testee.addListener((RegistrationKey)KEY_1, listener5, NOOP);
            Mono listeners = MailboxListenerRegistryTest.this.testee.getLocalMailboxListeners((RegistrationKey)KEY_1).publishOn(Schedulers.elastic()).delayElements(Duration.ofMillis(100L)).collectList();
            MailboxListenerRegistryTest.this.testee.removeListener((RegistrationKey)KEY_1, listener5, NOOP);
            Assertions.assertThat((List)((List)listeners.block(Duration.ofSeconds(10L)))).hasSize(5);
        }
    }
}

