/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class UserTest {
    UserTest() {
    }

    @Test
    void userShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.userWriters().writes((Object)Username.of((String)"bob"))).isEqualTo((Object)new JsString("bob"));
    }

    @Test
    void userShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Username)SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)new JsString("bob")).get())).isEqualTo((Object)Username.of((String)"bob"));
    }

    @Test
    void userShouldBeWellSerializedWhenVirtualHosting() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.userWriters().writes((Object)Username.of((String)"bob@domain"))).isEqualTo((Object)new JsString("bob@domain"));
    }

    @Test
    void userShouldBeWellDeSerializedWhenVirtualHosting() {
        Assertions.assertThat((Object)((Username)SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)new JsString("bob@domain")).get())).isEqualTo((Object)Username.of((String)"bob@domain"));
    }

    @Test
    void userDeserializationShouldReturnErrorWhenNumber() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
    }

    @Test
    void userDeserializationShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }

    @Test
    void userDeserializationShouldThrowWhenBadUsername() {
        Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)new JsString("bob@bad@bad"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void userDeserializationShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.userReads().reads((JsValue)new JsString(""))).isInstanceOf(IllegalArgumentException.class);
    }
}

