/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.Json;

class UpdatedFlagsTest {
    UpdatedFlagsTest() {
    }

    @Test
    void flagsUpdatedShouldThrowWhenMoqSeqIsAString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.updatedFlagsReads().reads(Json.parse((String)"      {        \"uid\": 123456,        \"modSeq\": \"35\",        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      }"))).isInstanceOf(JsError.class);
    }

    @Test
    void flagsUpdatedShouldThrowWhenMoqSeqIsNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.updatedFlagsReads().reads(Json.parse((String)"      {        \"uid\": 123456,        \"modSeq\": null,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      }"))).isInstanceOf(JsError.class);
    }

    @Test
    void flagsUpdatedShouldThrowWhenMoqSeqIsNotAnInteger() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.updatedFlagsReads().reads(Json.parse((String)"      {        \"uid\": 123456,        \"modSeq\": 35.2567454,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]},        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      }"))).isInstanceOf(JsError.class);
    }

    @Test
    void flagsUpdatedShouldThrowWhenOldFlagIsMissing() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.updatedFlagsReads().reads(Json.parse((String)"      {        \"uid\": 123456,        \"modSeq\": 35,        \"newFlags\": {\"systemFlags\":[\"Answered\",\"Draft\"],\"userFlags\":[\"New Flag 1\"]}      }"))).isInstanceOf(JsError.class);
    }

    @Test
    void flagsUpdatedShouldThrowWhenNewFlagIsMissing() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.updatedFlagsReads().reads(Json.parse((String)"      {        \"uid\": 123456,        \"modSeq\": 35,        \"oldFlags\": {\"systemFlags\":[\"Deleted\",\"Seen\"],\"userFlags\":[\"Old Flag 1\"]}      }"))).isInstanceOf(JsError.class);
    }
}

