/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.model.Quota;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import scala.math.BigDecimal;

class QuotaSizeTest {
    QuotaSizeTest() {
    }

    @Test
    void quotaSizeLimitShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeLimitWrites().writes((Object)QuotaSizeLimit.size((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void quotaSizeLimitShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaSizeLimit)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeLimitReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)QuotaSizeLimit.size((long)18L));
    }

    @Test
    void quotaSizeLimitShouldBeWellSerializedWhenUnlimited() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeLimitWrites().writes((Object)QuotaSizeLimit.unlimited())).isEqualTo((Object)JsNull$.MODULE$);
    }

    @Test
    void quotaSizeLimitShouldBeWellDeSerializedWhenUnlimited() {
        Assertions.assertThat((Object)((QuotaSizeLimit)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeLimitReads().reads((JsValue)JsNull$.MODULE$).get())).isEqualTo((Object)QuotaSizeLimit.unlimited());
    }

    @Test
    void quotaSizeLimitShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeLimitReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Test
    void quotaSizeUsageShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeUsageWrites().writes((Object)QuotaSizeUsage.size((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void quotaSizeUsageShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaSizeUsage)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeUsageReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)QuotaSizeUsage.size((long)18L));
    }

    @Test
    void quotaSizeUsageShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeUsageReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Nested
    class UnLimitedQuotaSize {
        UnLimitedQuotaSize() {
        }

        private Quota<QuotaSizeLimit, QuotaSizeUsage> unLimitedQuotaSizeByScopes(Quota.Scope scope) {
            return Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)12L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.unlimited()).limitForScope((QuotaLimitValue)QuotaSizeLimit.unlimited(), scope).build();
        }

        @Nested
        class UnLimitedQuotaUserScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = UnLimitedQuotaSize.this.unLimitedQuotaSizeByScopes(Quota.Scope.User);

            UnLimitedQuotaUserScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class UnLimitedQuotaDomainScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = UnLimitedQuotaSize.this.unLimitedQuotaSizeByScopes(Quota.Scope.Domain);

            UnLimitedQuotaDomainScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class UnLimitedQuotaGlobalScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = UnLimitedQuotaSize.this.unLimitedQuotaSizeByScopes(Quota.Scope.Global);

            UnLimitedQuotaGlobalScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }
    }

    @Nested
    class LimitedQuotaSize {
        LimitedQuotaSize() {
        }

        private Quota<QuotaSizeLimit, QuotaSizeUsage> limitedQuotaSizeByScopes(Quota.Scope scope) {
            return Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)12L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size((long)100L)).limitForScope((QuotaLimitValue)QuotaSizeLimit.size((long)100L), scope).build();
        }

        @Nested
        class LimitedQuotaUserScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = LimitedQuotaSize.this.limitedQuotaSizeByScopes(Quota.Scope.User);

            LimitedQuotaUserScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class LimitedQuotaDomainScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = LimitedQuotaSize.this.limitedQuotaSizeByScopes(Quota.Scope.Domain);

            LimitedQuotaDomainScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class LimitedQuotaGlobalScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}";
            private final Quota<QuotaSizeLimit, QuotaSizeUsage> quota = LimitedQuotaSize.this.limitedQuotaSizeByScopes(Quota.Scope.Global);

            LimitedQuotaGlobalScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaSize() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaSizeWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaSize() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaSReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }
    }
}

