/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.QuotaRoot;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class QuotaRootTest {
    QuotaRootTest() {
    }

    @Test
    void quotaRootWithDomainShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootWrites().writes((Object)QuotaRoot.quotaRoot((String)"bob@domain.tld", Optional.of(Domain.of((String)"domain.tld"))))).isEqualTo((Object)new JsString("bob@domain.tld"));
    }

    @Test
    void quotaRootWithDomainShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaRoot)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootReads().reads((JsValue)new JsString("#private&bob@domain.tld")).get())).isEqualTo((Object)QuotaRoot.quotaRoot((String)"#private&bob@domain.tld", Optional.of(Domain.of((String)"domain.tld"))));
    }

    @Test
    void quotaRootShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootWrites().writes((Object)QuotaRoot.quotaRoot((String)"bob", Optional.empty()))).isEqualTo((Object)new JsString("bob"));
    }

    @Test
    void quotaRootShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaRoot)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootReads().reads((JsValue)new JsString("#private&bob")).get())).isEqualTo((Object)QuotaRoot.quotaRoot((String)"#private&bob", Optional.empty()));
    }

    @Test
    void emptyQuotaRootShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootWrites().writes((Object)QuotaRoot.quotaRoot((String)"", Optional.empty()))).isEqualTo((Object)new JsString(""));
    }

    @Test
    void emptyQuotaRootShouldBeWellDeSerialized() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.quotaRootReads().reads((JsValue)new JsString("")).get()).isInstanceOf(MailboxException.class)).hasMessage(" used as QuotaRoot should contain exactly one \"&\"");
    }

    @Test
    void emptyQuotaRootShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }

    @Test
    void emptyQuotaRootShouldReturnErrorWhenNotString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaRootReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
    }
}

