/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.MessageUid;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class MessageUidTest {
    MessageUidTest() {
    }

    @Test
    void messageUidShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageUidWrites().writes((Object)MessageUid.of((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void messageUidShouldBeWellDeSerialized() {
        Assertions.assertThat((Comparable)((MessageUid)SerializerFixture.DTO_JSON_SERIALIZE.messageUidReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)MessageUid.of((long)18L));
    }

    @Test
    void messageUidShouldReturnErrorWhenFloat() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageUidReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((double)18.5)))).isInstanceOf(JsError.class);
    }

    @Test
    void messageUidShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageUidReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Test
    void messageUidShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageIdReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }
}

