/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class MailboxIdTest {
    MailboxIdTest() {
    }

    @Test
    void mailboxIdShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxIdWrites().writes((Object)TestId.of((long)18L))).isEqualTo((Object)new JsString("18"));
    }

    @Test
    void mailboxIdShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((MailboxId)SerializerFixture.DTO_JSON_SERIALIZE.mailboxIdReads().reads((JsValue)new JsString("18")).get())).isEqualTo((Object)TestId.of((long)18L));
    }

    @Test
    void mailboxIdDeserializationShouldReturnErrorWhenNumber() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxIdReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxIdDeserializationShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxIdReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxIdDeserializationShouldThrowWhenInvalid() {
        Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.mailboxIdReads().reads((JsValue)new JsString("invalid"))).isInstanceOf(IllegalArgumentException.class);
    }
}

