/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.time.Instant;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaUsageUpdatedEventSerializationTest {
    private static final QuotaRoot QUOTA_ROOT = QuotaRoot.quotaRoot((String)"#private&foo", Optional.empty());
    private static final Quota<QuotaCountLimit, QuotaCountUsage> QUOTA_COUNT = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)12L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)100L)).build();
    private static final Quota<QuotaSizeLimit, QuotaSizeUsage> QUOTA_SIZE = Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)1234L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size((long)10000L)).build();
    private static final Instant INSTANT = Instant.parse("2018-11-13T12:00:55Z");
    private final MailboxEvents.QuotaUsageUpdatedEvent eventWithUserContainsUsername = new MailboxEvents.QuotaUsageUpdatedEvent(SerializerFixture.EVENT_ID, Username.of((String)"onlyusername"), QUOTA_ROOT, QUOTA_COUNT, QUOTA_SIZE, INSTANT);
    private final String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{}},        \"time\":\"2018-11-13T12:00:55Z\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"onlyusername\"    }}";

    QuotaUsageUpdatedEventSerializationTest() {
    }

    @Test
    void fromJsonShouldReturnQuotaEvent() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{}},        \"time\":\"2018-11-13T12:00:55Z\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"onlyusername\"    }}").get())).isEqualTo((Object)this.eventWithUserContainsUsername);
    }

    @Test
    void toJsonShouldReturnQuotaEventJson() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)this.eventWithUserContainsUsername)).isEqualTo((Object)"{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{}},        \"time\":\"2018-11-13T12:00:55Z\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"onlyusername\"    }}");
    }

    @Test
    void fromJsonShouldThrowResultWhenUserIsMissing() {
        String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{}},        \"time\":\"2018-11-13T12:00:55Z\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}}    }}";
        Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(quotaUsageUpdatedEvent).get()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void fromJsonShouldThrowWhenCountQuotaIsMissing() {
        String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"time\":\"2018-11-13T12:00:55Z\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"onlyusername\"    }}";
        Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(quotaUsageUpdatedEvent).get()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void fromJsonShouldThrowWhenSizeQuotaIsMissing() {
        String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"time\":\"2018-11-13T12:00:55Z\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{}},        \"user\":\"onlyusername\"    }}";
        Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(quotaUsageUpdatedEvent).get()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void fromJsonShouldThrowResultWhenTimeIsNull() {
        String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}},        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"user\"    }}";
        Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(quotaUsageUpdatedEvent).get()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void fromJsonShouldThrowResultWhenTimeIsEmpty() {
        String quotaUsageUpdatedEvent = "{    \"QuotaUsageUpdatedEvent\":{        \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",        \"quotaRoot\":\"#private&foo\",        \"countQuota\":{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}},        \"time\":\"\",        \"sizeQuota\":{\"used\":1234,\"limit\":10000,\"limits\":{}},        \"user\":\"user\"    }}";
        Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(quotaUsageUpdatedEvent).get()).isInstanceOf(NoSuchElementException.class);
    }
}

