/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.util.NoSuchElementException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MessageMoveEventSerializationTest {
    private static final Event EVENT = MessageMoveEvent.builder().eventId(SerializerFixture.EVENT_ID).user(Username.of((String)"bob@domain.tld")).messageId((MessageId)TestMessageId.of((long)42L)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of((long)18L), TestId.of((long)24L)}).targetMailboxIds(new MailboxId[]{TestId.of((long)36L)}).build()).build();
    private static final String JSON = "{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}";

    MessageMoveEventSerializationTest() {
    }

    @Test
    void messageMoveEventShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson(EVENT)).isEqualTo((Object)JSON);
    }

    @Test
    void messageMoveEventShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(JSON).get())).isEqualTo((Object)EVENT);
    }

    @Nested
    class InvalidPayloads {
        InvalidPayloads() {
        }

        @Test
        void nullPreviousMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": null,    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void missingEventIdMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": null,    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonCollectionPreviousMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": 42,    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonStringElementInPreviousMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [42],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nullElementInPreviousMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [null],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nullTargetMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": null,    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonCollectionTargetMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": 42,    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonStringElementInTargetMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [42],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nullElementInTargetMailboxIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [null],    \"messageIds\": [\"42\"]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nullMessageIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [\"42\"],    \"messageIds\": null  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonCollectionMessageIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [\"42\"],    \"messageIds\": 42  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nonStringElementInMessageIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [\"42\"],    \"messageIds\": [42]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void nullElementInMessageIdsShouldBeRejected() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob@domain.tld\",    \"previousMailboxIds\": [\"36\"],    \"targetMailboxIds\": [\"42\"],    \"messageIds\": [null]  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class ValidPayloads {
        ValidPayloads() {
        }

        @Nested
        class EmptyMessagesIds {
            private final Event event = MessageMoveEvent.builder().eventId(SerializerFixture.EVENT_ID).user(Username.of((String)"bob")).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of((long)18L), TestId.of((long)24L)}).targetMailboxIds(new MailboxId[]{TestId.of((long)36L)}).build()).build();
            private final String json = "{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": []  }}";

            EmptyMessagesIds() {
            }

            @Test
            void messageMoveEventShouldBeWellSerialized() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson(this.event)).isEqualTo((Object)"{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": []  }}");
            }

            @Test
            void messageMoveEventShouldBeWellDeSerialized() {
                Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": []  }}").get())).isEqualTo((Object)this.event);
            }
        }

        @Nested
        class EmptyPreviousMailboxIds {
            private final Event event = MessageMoveEvent.builder().eventId(SerializerFixture.EVENT_ID).user(Username.of((String)"bob")).messageId((MessageId)TestMessageId.of((long)42L)).messageMoves(MessageMoves.builder().targetMailboxIds(new MailboxId[]{TestId.of((long)36L)}).build()).build();
            private final String json = "{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}";

            EmptyPreviousMailboxIds() {
            }

            @Test
            void messageMoveEventShouldBeWellSerialized() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson(this.event)).isEqualTo((Object)"{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}");
            }

            @Test
            void messageMoveEventShouldBeWellDeSerialized() {
                Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [],    \"targetMailboxIds\": [\"36\"],    \"messageIds\": [\"42\"]  }}").get())).isEqualTo((Object)this.event);
            }
        }

        @Nested
        class EmptyTargetMailboxIds {
            private final Event event = MessageMoveEvent.builder().eventId(SerializerFixture.EVENT_ID).user(Username.of((String)"bob")).messageId((MessageId)TestMessageId.of((long)42L)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of((long)18L), TestId.of((long)24L)}).build()).build();
            private final String json = "{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [],    \"messageIds\": [\"42\"]  }}";

            EmptyTargetMailboxIds() {
            }

            @Test
            void messageMoveEventShouldBeWellSerialized() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson(this.event)).isEqualTo((Object)"{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [],    \"messageIds\": [\"42\"]  }}");
            }

            @Test
            void messageMoveEventShouldBeWellDeSerialized() {
                Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MessageMoveEvent\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\": \"bob\",    \"previousMailboxIds\": [\"18\", \"24\"],    \"targetMailboxIds\": [],    \"messageIds\": [\"42\"]  }}").get())).isEqualTo((Object)this.event);
            }
        }
    }
}

