/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.util.NoSuchElementException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxRenamedSerializationTest {
    private static final Username DEFAULT_USERNAME = Username.of((String)"user");
    private static final String OLD_MAILBOX_NAME = "oldMailboxName";
    private static final MailboxPath DEFAULT_OLD_MAILBOX_PATH = new MailboxPath("#private", DEFAULT_USERNAME, "oldMailboxName");
    private static final String NEW_MAILBOX_NAME = "newMailboxName";
    private static final MailboxPath DEFAULT_NEW_MAILBOX_PATH = new MailboxPath("#private", DEFAULT_USERNAME, "newMailboxName");
    private static final MailboxSession.SessionId DEFAULT_SESSION_ID = MailboxSession.SessionId.of((long)123456789L);
    private static final MailboxId DEFAULT_MAILBOX_ID = TestId.of((long)123456L);
    private static final MailboxEvents.MailboxRenamed DEFAULT_MAILBOX_RENAMED_EVENT = new MailboxEvents.MailboxRenamed(DEFAULT_SESSION_ID, DEFAULT_USERNAME, DEFAULT_OLD_MAILBOX_PATH, DEFAULT_MAILBOX_ID, DEFAULT_NEW_MAILBOX_PATH, SerializerFixture.EVENT_ID);
    private static final String DEFAULT_MAILBOX_RENAMED_EVENT_JSON = "{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":123456789,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"     },    \"mailboxId\":\"123456\",    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}";

    MailboxRenamedSerializationTest() {
    }

    @Test
    void mailboxRenamedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)DEFAULT_MAILBOX_RENAMED_EVENT)).isEqualTo((Object)DEFAULT_MAILBOX_RENAMED_EVENT_JSON);
    }

    @Test
    void mailboxRenamedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_MAILBOX_RENAMED_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_MAILBOX_RENAMED_EVENT);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":123456789,    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"     },    \"mailboxId\":\"123456\",    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingSessionId() {
            String eventWithNullSessionId = "{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"     },    \"mailboxId\":\"123456\",    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}";
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(eventWithNullSessionId).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingEventId() {
            String eventWithNullSessionId = "{  \"MailboxRenamed\":{    \"sessionId\":42,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"     },    \"mailboxId\":\"123456\",    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}";
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson(eventWithNullSessionId).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":123456789,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"    },    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingOldPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":123456789,    \"user\":\"user\",    \"mailboxId\":123456,    \"newPath\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"newMailboxName\"     }  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxRenamedDeSerializeShouldThrowWhenMissingNewPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxRenamed\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"sessionId\":123456789,    \"user\":\"user\",    \"path\":{      \"namespace\":\"#private\",      \"user\":\"user\",      \"name\":\"oldMailboxName\"    },    \"mailboxId\":123456  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }
}

