/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import java.util.Map;
import java.util.NoSuchElementException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxACLUpdatedEventSerializationTest {
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxACL.EntryKey ENTRY_KEY = MailboxACL.EntryKey.createGroupEntryKey((String)"any", (boolean)false);
    private static final MailboxACL.Rfc4314Rights RIGHTS = new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Administer, MailboxACL.Right.Read});
    private static final MailboxACL MAILBOX_ACL = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(ENTRY_KEY, RIGHTS), new MailboxACL.Entry(MailboxACL.EntryKey.createUserEntryKey((Username)Username.of((String)"alice"), (boolean)true), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Insert}))});
    private static final MailboxEvents.MailboxACLUpdated MAILBOX_ACL_UPDATED = new MailboxEvents.MailboxACLUpdated(MailboxSession.SessionId.of((long)6L), USERNAME, new MailboxPath("#private", Username.of((String)"bob"), "mailboxName"), ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MAILBOX_ACL), (MailboxId)TestId.of((long)23L), SerializerFixture.EVENT_ID);
    private static final String MAILBOX_ACL_UPDATED_JSON = "{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":\"#private\",       \"user\":\"bob\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\", \"-alice\":\"i\"}},    \"mailboxId\":\"23\",    \"sessionId\":6,    \"user\":\"user\"   }}";

    MailboxACLUpdatedEventSerializationTest() {
    }

    @Test
    void mailboxACLUpdatedShouldBeSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)MAILBOX_ACL_UPDATED)).isEqualTo((Object)MAILBOX_ACL_UPDATED_JSON);
    }

    @Test
    void mailboxACLUpdatedShouldBeDeserialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(MAILBOX_ACL_UPDATED_JSON).get())).isEqualTo((Object)MAILBOX_ACL_UPDATED);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":\"#private\",       \"user\":\"bob\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\"}},    \"mailboxId\":\"23\",    \"user\":\"user\"   }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"sessionId\":42,    \"mailboxPath\":{       \"namespace\":\"#private\",       \"user\":\"bob\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\"}},    \"mailboxId\":\"23\",    \"user\":\"user\"   }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":\"#private\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\"}},    \"mailboxId\":\"23\",    \"sessionId\":6   }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingACLDiff() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":\"#private\",       \"name\":\"mailboxName\"      },    \"mailboxId\":\"23\",    \"sessionId\":6,    \"user\":\"user\"   }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":\"#private\",       \"user\":\"bob\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\"}},    \"sessionId\":6,    \"user\":\"user\"   }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void mailboxACLUpdatedShouldThrowWhenMissingMailboxPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"MailboxACLUpdated\":{    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxPath\":{       \"namespace\":230192.06,       \"user\":\"bob\",       \"name\":\"mailboxName\"      },    \"aclDiff\":{       \"oldACL\":{},       \"newACL\":{\"$any\":\"ar\"}},    \"mailboxId\":\"123\",    \"sessionId\":6,    \"user\":\"user\"   }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }
}

