/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json;

import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import javax.mail.Flags;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.events.Event;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class AddedSerializationTest {
    private static final Username USERNAME = Username.of((String)"user");
    private static final MailboxSession.SessionId SESSION_ID = MailboxSession.SessionId.of((long)42L);
    private static final MailboxId MAILBOX_ID = TestId.of((long)18L);
    private static final String MAILBOX_NAME = "mailboxName";
    private static final MailboxPath MAILBOX_PATH = new MailboxPath("#private", Username.of((String)"user"), "mailboxName");
    private static final MessageUid MESSAGE_UID = MessageUid.of((long)123456L);
    private static final Instant INSTANT = Instant.parse("2018-12-14T09:41:51.541Z");
    private static final TestMessageId MESSAGE_ID = TestMessageId.of((long)42L);
    private static final ModSeq MOD_SEQ = ModSeq.of((long)35L);
    private static final int SIZE = 45;
    private static final Flags FLAGS = FlagsBuilder.builder().add(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.DRAFT}).add(new String[]{"User Custom Flag"}).build();
    private static final SortedMap<MessageUid, MessageMetaData> ADDED = ImmutableSortedMap.of((Comparable)MESSAGE_UID, (Object)new MessageMetaData(MESSAGE_UID, MOD_SEQ, FLAGS, 45L, Date.from(INSTANT), (MessageId)MESSAGE_ID, ThreadId.fromBaseMessageId((MessageId)MESSAGE_ID)));
    private static final SortedMap<MessageUid, MessageMetaData> ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID = ImmutableSortedMap.of((Comparable)MESSAGE_UID, (Object)new MessageMetaData(MESSAGE_UID, MOD_SEQ, FLAGS, 45L, Date.from(INSTANT), (MessageId)MESSAGE_ID, ThreadId.fromBaseMessageId((MessageId)TestMessageId.of((long)100L))));
    private static final MailboxEvents.Added DEFAULT_ADDED_EVENT = new MailboxEvents.Added(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, ADDED, SerializerFixture.EVENT_ID);
    private static final MailboxEvents.Added ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID_EVENT = new MailboxEvents.Added(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID, SerializerFixture.EVENT_ID);
    private static final String DEFAULT_ADDED_EVENT_JSON = "{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\",        \"threadId\":\"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}";
    private static final String ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID_EVENT_JSON = "{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\",        \"threadId\":\"100\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}";
    private static final String DEFAULT_BACKWARD_ADDED_EVENT_JSON = "{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}";

    AddedSerializationTest() {
    }

    @Test
    void addedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)DEFAULT_ADDED_EVENT)).isEqualTo((Object)DEFAULT_ADDED_EVENT_JSON);
    }

    @Test
    void addedWithDistinctMessageIdAndThreadIdShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID_EVENT)).isEqualTo((Object)ADDED_WITH_DISTINCT_MESSAGE_ID_AND_THREAD_ID_EVENT_JSON);
    }

    @Test
    void addedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_ADDED_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_ADDED_EVENT);
    }

    @Test
    void previousAddedFormatShouldBeWellDeserialized() {
        Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson(DEFAULT_BACKWARD_ADDED_EVENT_JSON).get())).isEqualTo((Object)DEFAULT_ADDED_EVENT);
    }

    @Nested
    class DeserializationErrors {
        DeserializationErrors() {
        }

        @Test
        void addedShouldThrowWhenMissingEventId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"sessionId\":42,    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMissingSessionId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMissingUser() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMissingMailboxId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMissingPath() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"mailboxId\": \"18\",    \"added\": {      \"123456\": {        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"      }    },    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMapKeyIsNull() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": null,    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void addedShouldThrowWhenMissingAdded() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"sessionId\": 42,    \"user\": \"user\"  }}").get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class WithEmptyAddedMap {
        private final MailboxEvents.Added emptyAddedEvent = new MailboxEvents.Added(SESSION_ID, USERNAME, MAILBOX_PATH, MAILBOX_ID, (SortedMap)ImmutableSortedMap.of(), SerializerFixture.EVENT_ID);
        private final String emptyAddedEventJson = "{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}";

        WithEmptyAddedMap() {
        }

        @Test
        void addedShouldBeWellSerializedWhenMapKeyIsEmpty() {
            JsonAssertions.assertThatJson((Object)SerializerFixture.EVENT_SERIALIZER.toJson((Event)this.emptyAddedEvent)).isEqualTo((Object)"{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}");
        }

        @Test
        void addedShouldBeWellDeSerializedWhenMapKeyIsEmpty() {
            Assertions.assertThat((Object)((Event)SerializerFixture.EVENT_SERIALIZER.fromJson("{  \"Added\": {    \"eventId\":\"6e0dd59d-660e-4d9b-b22f-0354479f47b4\",    \"path\": {      \"namespace\": \"#private\",      \"user\": \"user\",      \"name\": \"mailboxName\"    },    \"mailboxId\": \"18\",    \"added\": {},    \"sessionId\": 42,    \"user\": \"user\"  }}").get())).isEqualTo((Object)this.emptyAddedEvent);
        }
    }
}

