/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.model.Quota;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import scala.math.BigDecimal;

class QuotaCountTest {
    QuotaCountTest() {
    }

    @Test
    void quotaCountLimitShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountLimitWrites().writes((Object)QuotaCountLimit.count((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void quotaCountLimitShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaCountLimit)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountLimitReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)QuotaCountLimit.count((long)18L));
    }

    @Test
    void quotaCountLimitShouldBeWellSerializedWhenUnlimited() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountLimitWrites().writes((Object)QuotaCountLimit.unlimited())).isEqualTo((Object)JsNull$.MODULE$);
    }

    @Test
    void quotaCountLimitShouldBeWellDeSerializedWhenUnlimited() {
        Assertions.assertThat((Object)((QuotaCountLimit)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountLimitReads().reads((JsValue)JsNull$.MODULE$).get())).isEqualTo((Object)QuotaCountLimit.unlimited());
    }

    @Test
    void quotaCountLimitShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountLimitReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Test
    void quotaCountUsageShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountUsageWrites().writes((Object)QuotaCountUsage.count((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void quotaCountUsageShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((QuotaCountUsage)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountUsageReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)QuotaCountUsage.count((long)18L));
    }

    @Test
    void quotaCountUsageShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountUsageReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Nested
    class UnknownQuotaScope {
        private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"Invalid\":100}}";

        UnknownQuotaScope() {
        }

        @Test
        void fromJsonShouldThrowOnInvalidScope() {
            Assertions.assertThatThrownBy(() -> ((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"Invalid\":100}}")).get()).toJava()).isInstanceOf(IllegalArgumentException.class);
        }

        @Test
        void scopesShouldBeString() {
            Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaScopeReads().reads(Json.parse((String)"3"))).isInstanceOf(JsError.class);
        }
    }

    @Nested
    class UnLimitedQuotaCount {
        UnLimitedQuotaCount() {
        }

        private Quota<QuotaCountLimit, QuotaCountUsage> unLimitedQuotaCountByScopes(Quota.Scope scope) {
            return Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)12L)).computedLimit((QuotaLimitValue)QuotaCountLimit.unlimited()).limitForScope((QuotaLimitValue)QuotaCountLimit.unlimited(), scope).build();
        }

        @Nested
        class UnLimitedQuotaUserScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = UnLimitedQuotaCount.this.unLimitedQuotaCountByScopes(Quota.Scope.User);

            UnLimitedQuotaUserScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"User\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class UnLimitedQuotaDomainScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = UnLimitedQuotaCount.this.unLimitedQuotaCountByScopes(Quota.Scope.Domain);

            UnLimitedQuotaDomainScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"Domain\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class UnLimitedQuotaGlobalScope {
            private final String json = "{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = UnLimitedQuotaCount.this.unLimitedQuotaCountByScopes(Quota.Scope.Global);

            UnLimitedQuotaGlobalScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":null,\"limits\":{\"Global\":null}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }
    }

    @Nested
    class LimitedQuotaCount {
        LimitedQuotaCount() {
        }

        private Quota<QuotaCountLimit, QuotaCountUsage> limitedQuotaCountByScopes(Quota.Scope scope) {
            return Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)12L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)100L)).limitForScope((QuotaLimitValue)QuotaCountLimit.count((long)100L), scope).build();
        }

        @Nested
        class LimitedQuotaUserScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = LimitedQuotaCount.this.limitedQuotaCountByScopes(Quota.Scope.User);

            LimitedQuotaUserScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"User\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class LimitedQuotaDomainScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = LimitedQuotaCount.this.limitedQuotaCountByScopes(Quota.Scope.Domain);

            LimitedQuotaDomainScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"Domain\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }

        @Nested
        class LimitedQuotaGlobalScope {
            private final String json = "{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}";
            private final Quota<QuotaCountLimit, QuotaCountUsage> quota = LimitedQuotaCount.this.limitedQuotaCountByScopes(Quota.Scope.Global);

            LimitedQuotaGlobalScope() {
            }

            @Test
            void toJsonShouldSerializeQuotaCount() {
                JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.quotaCountWrites().writes((Object)DTOs.Quota$.MODULE$.toScala(this.quota)).toString()).isEqualTo((Object)"{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}");
            }

            @Test
            void fromJsonShouldDeserializeQuotaCount() {
                Assertions.assertThat((Object)((DTOs.Quota)SerializerFixture.DTO_JSON_SERIALIZE.quotaCReads().reads(Json.parse((String)"{\"used\":12,\"limit\":100,\"limits\":{\"Global\":100}}")).get()).toJava()).isEqualTo(this.quota);
            }
        }
    }
}

