/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.ModSeq;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class ModSeqTest {
    ModSeqTest() {
    }

    @Test
    void modSeqShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.modSeqWrites().writes((Object)ModSeq.of((long)18L))).isEqualTo((Object)new JsNumber(BigDecimal.valueOf((long)18L)));
    }

    @Test
    void modSeqShouldBeWellDeSerialized() {
        Assertions.assertThat((Comparable)((ModSeq)SerializerFixture.DTO_JSON_SERIALIZE.modSeqReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L))).get())).isEqualTo((Object)ModSeq.of((long)18L));
    }

    @Test
    void modSeqShouldReturnErrorWhenFloat() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.modSeqReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((double)18.5)))).isInstanceOf(JsError.class);
    }

    @Test
    void modSeqShouldReturnErrorWhenString() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.modSeqReads().reads((JsValue)new JsString("18"))).isInstanceOf(JsError.class);
    }

    @Test
    void modSeqShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.modSeqReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }
}

