/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import java.time.Instant;
import java.util.NoSuchElementException;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import play.api.libs.json.Json;

class MessageMetaDataTest {
    MessageMetaDataTest() {
    }

    @Nested
    class DeserializationErrorOnInternalDate {
        DeserializationErrorOnInternalDate() {
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsNotInISOFormatBecauseOfMissingTWord() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14 12:52:36+07:00\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateContainsOnlyDate() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsMissingHourPart() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14TZ\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsMissingTimeZone() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsMissingHours() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsEmpty() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldThrowWhenInternalDateIsNull() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": null,        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deSerializeShouldParseValidISOInstants() {
            Assertions.assertThat((Instant)((DTOs.MessageMetaData)SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14T09:41:51+00:00\",        \"messageId\": \"42\"}")).get()).internalDate()).isEqualTo((Object)Instant.parse("2018-12-14T09:41:51Z"));
        }

        @Test
        void deSerializeShouldParseWhenInternalDateIsMissingMilliSeconds() {
            Assertions.assertThat((Instant)((DTOs.MessageMetaData)SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": 42,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14T09:41:51+00:00\",        \"messageId\": \"42\"}")).get()).internalDate()).isEqualTo((Object)Instant.parse("2018-12-14T09:41:51Z"));
        }
    }

    @Nested
    class SizeTest {
        SizeTest() {
        }

        @Test
        void deserializeShouldThrowWhenNullSize() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": null,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenStringSize() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"size\": \"42\",        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"modSeq\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class ModSeqTest {
        ModSeqTest() {
        }

        @Test
        void deserializeShouldThrowWhenNullModSeq() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": null,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenStringModSeq() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": \"42\",        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Nested
    class StructureTest {
        StructureTest() {
        }

        @Test
        void deserializeShouldThrowWhenNoFlags() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": 35,        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenNoUid() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenNoModSeq() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenNoSize() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"internalDate\": \"2018-12-14T09:41:51.541Z\",        \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenNoInternalDate() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"messageId\": \"42\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }

        @Test
        void deserializeShouldThrowWhenNoMessageId() {
            Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageMetaDataReads().reads(Json.parse((String)"{        \"uid\": 123456,        \"modSeq\": 35,        \"flags\": {          \"systemFlags\":[\"Answered\",\"Draft\"],           \"userFlags\":[\"User Custom Flag\"]},        \"size\": 45,          \"internalDate\": \"2018-12-14T09:41:51.541Z\"}")).get()).isInstanceOf(NoSuchElementException.class);
        }
    }
}

