/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.math.BigDecimal;

class MessageIdTest {
    MessageIdTest() {
    }

    @Test
    void messageIdShouldBeWellSerialized() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageIdWrites().writes((Object)TestMessageId.of((long)18L))).isEqualTo((Object)new JsString("18"));
    }

    @Test
    void messageIdShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((MessageId)SerializerFixture.DTO_JSON_SERIALIZE.messageIdReads().reads((JsValue)new JsString("18")).get())).isEqualTo((Object)TestMessageId.of((long)18L));
    }

    @Test
    void messageIdDeserializationShouldReturnErrorWhenNumber() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageIdReads().reads((JsValue)new JsNumber(BigDecimal.valueOf((long)18L)))).isInstanceOf(JsError.class);
    }

    @Test
    void messageIdDeserializationShouldReturnErrorWhenNull() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.messageIdReads().reads((JsValue)JsNull$.MODULE$)).isInstanceOf(JsError.class);
    }

    @Test
    void messageIdDeserializationShouldThrowWhenInvalid() {
        Assertions.assertThatThrownBy(() -> SerializerFixture.DTO_JSON_SERIALIZE.messageIdReads().reads((JsValue)new JsString("invalid"))).isInstanceOf(IllegalArgumentException.class);
    }
}

