/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.core.Username;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.apache.james.mailbox.model.MailboxPath;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.JsError;
import play.api.libs.json.Json;

class MailboxPathTest {
    private static final String MAILBOX_NAME = "mailboxName";
    public static final Username USER = Username.of((String)"user");
    private static final MailboxPath MAILBOX_PATH = new MailboxPath("#private", USER, "mailboxName");

    MailboxPathTest() {
    }

    @Test
    void mailboxPathShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathWrites().writes((Object)DTOs.MailboxPath$.MODULE$.fromJava(MAILBOX_PATH)).toString()).isEqualTo((Object)"{  \"namespace\":\"#private\",  \"user\":\"user\",  \"name\":\"mailboxName\"}");
    }

    @Test
    void mailboxPathWithEmptyNamespaceShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathWrites().writes((Object)DTOs.MailboxPath$.MODULE$.fromJava(new MailboxPath("", USER, MAILBOX_NAME))).toString()).isEqualTo((Object)"{  \"namespace\":\"#private\",  \"user\":\"user\",  \"name\":\"mailboxName\"}");
    }

    @Test
    void mailboxPathWithShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)((DTOs.MailboxPath)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":\"#private\",  \"user\":\"user\",  \"name\":\"mailboxName\"}")).get())).isEqualTo((Object)DTOs.MailboxPath$.MODULE$.fromJava(new MailboxPath("#private", USER, MAILBOX_NAME)));
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenNoNamespace() {
        Assertions.assertThat((Object)((DTOs.MailboxPath)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"user\":\"user\",  \"name\":\"mailboxName\"}")).get()).toJava()).isEqualTo((Object)new MailboxPath("#private", USER, MAILBOX_NAME));
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenNullNamespace() {
        Assertions.assertThat((Object)((DTOs.MailboxPath)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":null,  \"user\":\"user\",  \"name\":\"mailboxName\"}")).get()).toJava()).isEqualTo((Object)new MailboxPath("#private", USER, MAILBOX_NAME));
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenLongNamespace() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":18,  \"user\":\"user\",  \"name\":\"mailboxName\"}"))).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenLongUser() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":\"#private\",  \"user\":42,  \"name\":\"mailboxName\"}"))).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenMissingMailboxName() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":\"#private\",  \"user\":\"user\"}"))).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenNullMailboxName() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":\"#private\",  \"user\":\"user\",  \"name\":null}"))).isInstanceOf(JsError.class);
    }

    @Test
    void mailboxPathDeserializationShouldFailWhenLongMailboxName() {
        Assertions.assertThat((Object)SerializerFixture.DTO_JSON_SERIALIZE.mailboxPathReads().reads(Json.parse((String)"{  \"namespace\":\"#private\",  \"user\":\"user\",  \"name\":42}"))).isInstanceOf(JsError.class);
    }
}

