/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.json.dtos;

import java.util.NoSuchElementException;
import javax.mail.Flags;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.event.json.DTOs;
import org.apache.james.event.json.SerializerFixture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import play.api.libs.json.Json;

class FlagsTest {
    FlagsTest() {
    }

    @Test
    void emptyFlagsShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags())).toString()).isEqualTo((Object)"{\"systemFlags\":[],\"userFlags\":[]}");
    }

    @Test
    void answeredShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.ANSWERED))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Answered\"],\"userFlags\":[]}");
    }

    @Test
    void deletedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.DELETED))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Deleted\"],\"userFlags\":[]}");
    }

    @Test
    void draftShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.DRAFT))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Draft\"],\"userFlags\":[]}");
    }

    @Test
    void flaggedShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.FLAGGED))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Flagged\"],\"userFlags\":[]}");
    }

    @Test
    void recentShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.RECENT))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Recent\"],\"userFlags\":[]}");
    }

    @Test
    void seenShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags(Flags.Flag.SEEN))).toString()).isEqualTo((Object)"{\"systemFlags\":[\"Seen\"],\"userFlags\":[]}");
    }

    @Test
    void userFlagShouldBeWellSerialized() {
        JsonAssertions.assertThatJson((Object)SerializerFixture.DTO_JSON_SERIALIZE.flagWrites().writes((Object)DTOs.Flags$.MODULE$.fromJavaFlags(new Flags("user flag"))).toString()).isEqualTo((Object)"{\"systemFlags\":[],\"userFlags\":[\"user flag\"]}");
    }

    @Test
    void emptyFlagsShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags());
    }

    @Test
    void answeredShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Answered\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.ANSWERED));
    }

    @Test
    void deletedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Deleted\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.DELETED));
    }

    @Test
    void draftShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Draft\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.DRAFT));
    }

    @Test
    void flaggedShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Flagged\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.FLAGGED));
    }

    @Test
    void recentShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Recent\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.RECENT));
    }

    @Test
    void seenShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"Seen\"],\"userFlags\":[]}")).get())).isEqualTo((Object)new Flags(Flags.Flag.SEEN));
    }

    @Test
    void userFlagShouldBeWellDeSerialized() {
        Assertions.assertThat((Object)DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[],\"userFlags\":[\"user flag\"]}")).get())).isEqualTo((Object)new Flags("user flag"));
    }

    @Test
    void deserializeShouldThrowWhenUnknownSystemFlag() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"unknown\"],\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenBadCaseSystemFlag() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[\"AnSwErEd\"],\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenNullSystemFlag() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":null,\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenSystemFlagContainsNullElements() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[null,\"Draft\"],\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenSystemFlagContainsNotStringElements() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[42,\"Draft\"],\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenUserFlagsContainsNullElements() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[],\"userFlags\":[null, \"a\"]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenUserFlagsContainsNonStringElements() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[],\"userFlags\":[42, \"a\"]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenNoUserFlags() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"systemFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    void deserializeShouldThrowWhenNoSystemFlags() {
        Assertions.assertThatThrownBy(() -> DTOs.Flags$.MODULE$.toJavaFlags((DTOs.Flags)SerializerFixture.DTO_JSON_SERIALIZE.flagsReads().reads(Json.parse((String)"{\"userFlags\":[]}")).get())).isInstanceOf(NoSuchElementException.class);
    }
}

